test_that("f infers types correctly", {
  expect_equal(neatR:::.infer_type(Sys.Date()), "date")
  expect_equal(neatR:::.infer_type(Sys.time()), "ts")
  expect_equal(neatR:::.infer_type(123), "number")
  expect_equal(neatR:::.infer_type(12.34), "number")
  expect_equal(neatR:::.infer_type("hello"), "string")
})

test_that("f formats dates correctly", {
  d <- as.Date("2026-01-01")
  expect_equal(f(d), "Jan 01, 2026")
  expect_equal(f(d, format_type = "date"), "Jan 01, 2026")
  expect_match(f(d, show_weekday = TRUE), "Jan 01, 2026 \\(Thu\\)")
})

test_that("f formats days correctly", {
  d <- as.Date("2026-01-01")
  expect_equal(f(d, format_type = "day"), "Thu")
})

test_that("f formats timestamps correctly", {
  ts <- as.POSIXct("2026-01-01 12:00:00", tz = "UTC")
  expect_match(f(ts), "Jan 01, 2026 12H 00M 00S PM UTC \\(Thu\\)")
  expect_match(
    f(ts, show_timezone = FALSE), "Jan 01, 2026 12H 00M 00S PM \\(Thu\\)"
  )
})

test_that("f formats numbers correctly", {
  expect_equal(f(1000), "1.0 K")
  expect_equal(f(1000, format_type = "number"), "1.0 K")
  expect_equal(f(1000, unit = "custom", thousand_separator = "."), "1.0 K")
  expect_equal(f(1234.56, digits = 2), "1.23 K")
})

test_that("f formats percents correctly", {
  p1 <- 9.0
  expected1 <- "+900.0% (9x growth, 90K basis points)"
  expect_equal(f(p1, format_type = "percent"), expected1)
  p2 <- -0.5
  expected2 <- "-50.0% (0.5x drop, -5K basis points)"
  expect_equal(f(p2, format_type = "percent"), expected2)
  p3 <- 50
  expected_p3 <- "+50.0% (0.5x growth, 5K basis points)"
  expect_equal(f(p3, format_type = "percent", is_ratio = FALSE), expected_p3)
})

test_that("f formats strings correctly", {
  s <- "  hello world  "
  expect_equal(f(s), "Hello World")
  expect_equal(f(s, format_type = "string"), "Hello World")
  expect_equal(f(s, case = "upper"), "HELLO WORLD")
})
