% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_sc.R
\name{match_map_sc_seurat}
\alias{match_map_sc_seurat}
\title{Match Single-Cell Expression Data with Phylostratum Map (Seurat)}
\usage{
match_map_sc_seurat(
  seurat,
  phylomap,
  layer = "counts",
  strata_legend = NULL,
  ...
)
}
\arguments{
\item{seurat}{A Seurat object containing single-cell expression data}

\item{phylomap}{A data frame with two columns: phylostratum assignments and gene IDs}

\item{layer}{Character string specifying which layer to use from the Seurat object (default: "counts")}

\item{strata_legend}{A data frame with two columns: phylostratum assignments and name of each stratum. If NULL, numeric labels will be used (default: NULL)}

\item{...}{Additional arguments passed to ScPhyloExpressionSet_from_seurat}
}
\value{
A ScPhyloExpressionSet object
}
\description{
Join single-cell gene expression data (from a Seurat object) with a phylostratum mapping to create 
a ScPhyloExpressionSet object. Automatically extracts dimensional reductions and metadata.
}
\details{
This is a convenience function that combines phylostratum mapping with Seurat object conversion.
Only genes present in both the expression data and phylomap will be retained. The function
extracts all metadata and dimensional reductions from the Seurat object.
}
