% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_sc.R
\name{ScPhyloExpressionSet_from_matrix}
\alias{ScPhyloExpressionSet_from_matrix}
\title{Create Single-Cell PhyloExpressionSet from Expression Matrix}
\usage{
ScPhyloExpressionSet_from_matrix(
  expression_matrix,
  strata,
  metadata,
  groups_column = NULL,
  name = "Single-Cell Phylo Expression Set",
  ...
)
}
\arguments{
\item{expression_matrix}{Sparse or dense expression matrix with genes as rows and cells as columns}

\item{strata}{Factor vector of phylostratum assignments for each gene}

\item{metadata}{Data frame with cell metadata, rownames should match colnames of expression_matrix}

\item{groups_column}{Character string specifying which metadata column to use for initial grouping (default: first factor column found)}

\item{name}{A character string naming the dataset (default: "Single-Cell Phylo Expression Set")}

\item{...}{Additional arguments passed to ScPhyloExpressionSet constructor}
}
\value{
A ScPhyloExpressionSet object
}
\description{
Create a ScPhyloExpressionSet object from an expression matrix and metadata.
}
\details{
This function creates a ScPhyloExpressionSet from basic components. The \code{groups_column}
parameter determines the initial \code{selected_idents} value, which can be changed later
using the setter. All discrete columns in metadata are automatically converted to factors
for consistent handling.
}
