% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{mc_prep_expandtime}
\alias{mc_prep_expandtime}
\title{Expand time steps}
\usage{
mc_prep_expandtime(
  data,
  to_step,
  localities = NULL,
  loggers = NULL,
  from_step = NULL
)
}
\arguments{
\item{data}{cleaned myClim object see \link{myClim-package}}

\item{to_step}{new time step in seconds (e.g. 3600 for one hour)}

\item{localities}{IDs of localities to expand. If \code{NULL}, expands all localities (default)}

\item{loggers}{names of loggers to expand. If \code{NULL}, expands all loggers (default).}

\item{from_step}{original time step in seconds to expand.
If \code{NULL}, expands all loggers with a step longer than \code{to_step}.}
}
\value{
raw myClim data with expanded datetime.
}
\description{
Expands (downscales) time steps in raw myClim objects, e.g. from 1 hour to 15 minutes.
The original step must be a multiple of the new step (e.g. 15 → 5 minutes works,
but 15 → 10 minutes does not).
Newly created gaps in the expanded series are filled with \code{NA}.
}
\details{
Works only with raw myClim objects.
If \code{from_step} is specified, only loggers with this step are expanded;
loggers with other steps remain unchanged.
}
\examples{
mc_prep_expandtime(mc_data_example_clean, to_step = 300, localities = "A1E05", loggers = "Thermo_1")
}
