% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_automatic.R
\name{AUTOMATIC_Multi_MVFMR}
\alias{AUTOMATIC_Multi_MVFMR}
\title{Automatic Multivariable Functional MR with joint estimation (internal)}
\usage{
AUTOMATIC_Multi_MVFMR(
  Gmatrix,
  res1 = NA,
  res2 = NA,
  Yvector,
  IDmatch = NA,
  nPC1_selected = NA,
  max_nPC1 = NA,
  nPC2_selected = NA,
  max_nPC2 = NA,
  X1_true = matrix(),
  X2_true = matrix(),
  method = "gmm",
  basis = "eigenfunction",
  outcome = "continuous",
  bootstrap = FALSE,
  n_B = 10,
  improvement_threshold = 0.01,
  X1Ymodel = NA,
  X2Ymodel = NA,
  num_cores_set = NA,
  verbose = FALSE
)
}
\arguments{
\item{Gmatrix}{Genetic instrument matrix (N × J)}

\item{res1}{FPCA result for exposure 1}

\item{res2}{FPCA result for exposure 2}

\item{Yvector}{Outcome vector}

\item{IDmatch}{Optional index vector to match rows of Gmatrix and Yvector (default: 1:N)}

\item{nPC1_selected}{Fixed number of principal components to retain for exposure 1 (NA = select automatically)}

\item{max_nPC1}{Maximum number of principal components to consider for exposure 1 during selection}

\item{nPC2_selected}{Fixed number of principal components to retain for exposure 2 (NA = select automatically)}

\item{max_nPC2}{Maximum number of principal components to consider for exposure 2 during selection}

\item{X1_true}{Optional: true X1 curves (simulation only)}

\item{X2_true}{Optional: true X2 curves (simulation only)}

\item{method}{Estimation method: "gmm" (Generalized Method of Moments), "cf" (control function), or "cf-lasso" (control function with Lasso)}

\item{basis}{Basis type for functional representation: "eigenfunction" or "polynomial"}

\item{outcome}{Outcome type: "continuous" for numeric or "binary" for 0/1 outcomes}

\item{bootstrap}{Logical; whether to perform bootstrap inference for confidence intervals}

\item{n_B}{Number of bootstrap iterations (used only if bootstrap = TRUE)}

\item{improvement_threshold}{Minimum cross-validation improvement required to add an additional principal component}

\item{X1Ymodel}{Optional: true effect model for X1 on Y (simulation only)}

\item{X2Ymodel}{Optional: true effect model for X2 on Y (simulation only)}

\item{num_cores_set}{Number of CPU cores to use for parallel processing}

\item{verbose}{Print progress messages and diagnostics during computation}
}
\value{
List with estimation results, selected components, performance metrics
}
\description{
Core function that performs joint estimation of time-varying causal effects
from multiple correlated exposures using automatic component selection.
}
\keyword{internal}
