% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{VarCorr.brmcoda}
\alias{VarCorr.brmcoda}
\alias{VarCorr}
\title{Extract Variance and Correlation Components}
\usage{
\method{VarCorr}{brmcoda}(x, ...)
}
\arguments{
\item{x}{An object of class \code{brmcoda}.}

\item{...}{Further arguments passed to \code{\link[brms:VarCorr.brmsfit]{VarCorr.brmsfit}}.}
}
\value{
A list of lists (one per grouping factor), each with
three elements: a matrix containing the standard deviations,
an array containing the correlation matrix, and an array
containing the covariance matrix with variances on the diagonal.
}
\description{
Calculates the estimated standard deviations,
correlations and covariances of the group-level terms
of the \code{brmsfit} object in a \code{brmcoda} object.
}
\examples{
\donttest{
## fit a model
if(requireNamespace("cmdstanr")){
  m <- brmcoda(complr = complr(data = mcompd, sbp = sbp,
                               parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                               idvar = "ID", total = 1440),
               formula = Stress ~ bz1_1 + bz2_1 + bz3_1 + bz4_1 +
                                  wz1_1 + wz2_1 + wz3_1 + wz4_1 + (1 | ID),
                                 chain = 1, iter = 500,
                                 backend = "cmdstanr")

  VarCorr(m)
}}
}
\seealso{
\code{\link[brms:VarCorr.brmsfit]{VarCorr.brmsfit}}
}
