% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFinalSizeODE.R
\name{getFinalSizeODE}
\alias{getFinalSizeODE}
\title{Calculate outbreak final size, the total number of infections in each group, by numerically
solving the multi-group ordinary differential equation}
\usage{
getFinalSizeODE(transmrates, recoveryrate, popsize, initR, initI, initV)
}
\arguments{
\item{transmrates}{matrix of group-to-group (column-to-row) transmission rates}

\item{recoveryrate}{inverse of mean infectious period}

\item{popsize}{the population size of each group}

\item{initR}{initial number of each group already infected and removed (included in final size)}

\item{initI}{initial number of each group infectious}

\item{initV}{initial number of each group vaccinated}
}
\value{
vector of final sizes (number of infected over whole outbreak) for each group
}
\description{
Calculate outbreak final size, the total number of infections in each group, by numerically
solving the multi-group ordinary differential equation
}
\examples{
getFinalSizeODE(transmrates = matrix(0.2, 2 ,2), recoveryrate = 0.3,
popsize = c(100, 150), initR = c(0, 0), initI = c(0, 1), initV = c(10, 10))
}
