% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{optimize_RTMB}
\alias{optimize_RTMB}
\title{Optimize RTMB model}
\usage{
optimize_RTMB(
  obj,
  hessian = FALSE,
  restart = 0,
  do_sd = TRUE,
  control = list(iter.max = 2e+05, eval.max = 4e+05),
  lower = -Inf,
  upper = Inf,
  silent = FALSE
)
}
\arguments{
\item{obj}{The list returned by \code{\link[RTMB:TMB-interface]{RTMB::MakeADFun()}}}

\item{hessian}{Logical, whether to pass the Hessian function \code{obj$he} to \code{\link[stats:nlminb]{stats::nlminb()}}. Only used if
there are no random effects in the model.}

\item{restart}{Integer, the maximum number of additional attempts to fit the model. See details.}

\item{do_sd}{Logical, whether to calculate standard errors through \code{\link[=get_sdreport]{get_sdreport()}}}

\item{control}{List of options passed to \code{\link[stats:nlminb]{stats::nlminb()}}}

\item{lower}{Lower bounds of parameters passed to \code{\link[stats:nlminb]{stats::nlminb()}}}

\item{upper}{Upper bounds of parameters passed to \code{\link[stats:nlminb]{stats::nlminb()}}}

\item{silent}{Logical, whether to report progress to console}
}
\value{
A named list: "opt" is the output of \code{\link[stats:nlminb]{stats::nlminb()}} and "SD" is the output of \code{\link[=get_sdreport]{get_sdreport()}}
}
\description{
A convenient function that fits a RTMB model and calculates standard errors.
}
\details{
Argument \code{restart} allows for recursive model fitting to obtain convergence, through the following procedure:
\enumerate{
\item Optimize model with \code{\link[stats:nlminb]{stats::nlminb()}}.
\item Determine convergence, defined by \code{\link[RTMB:TMB-interface]{RTMB::sdreport()}} by whether the Cholesky decomposition of the covariance matrix is possible.
\item If convergence is not achieved, jitter parameter estimates with multiplicative factor \code{rlnorm(mean = 0, sd = 1e-3)} and return to step 1.
}
}
\seealso{
\code{\link[=get_sdreport]{get_sdreport()}}
}
\keyword{internal}
