% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_methods.R
\name{estimation_methods}
\alias{estimation_methods}
\title{Estimate Methods}
\usage{
estimation_methods(
  estimate,
  data,
  colnames,
  behrule,
  ids = NULL,
  models,
  funcs = NULL,
  priors = NULL,
  settings = NULL,
  algorithm,
  lowers,
  uppers,
  control,
  ...
)
}
\arguments{
\item{estimate}{Estimate method that you want to use, 
see \link[multiRL]{estimate}}

\item{data}{A data frame in which each row represents a single trial,
see \link[multiRL]{data}}

\item{colnames}{Column names in the data frame,
see \link[multiRL]{colnames}}

\item{behrule}{The agent’s implicitly formed internal rule,
see \link[multiRL]{behrule}}

\item{ids}{The Subject ID of the participant whose data needs to be fitted.}

\item{models}{Reinforcement Learning Models}

\item{funcs}{The functions forming the reinforcement learning model,
see \link[multiRL]{funcs}}

\item{priors}{Prior probability density function of the free parameters,
see \link[multiRL]{priors}}

\item{settings}{Other model settings, 
see \link[multiRL]{settings}}

\item{algorithm}{Algorithm packages that multiRL supports, 
see \link[multiRL]{algorithm}}

\item{lowers}{Lower bound of free parameters in each model.}

\item{uppers}{Upper bound of free parameters in each model.}

\item{control}{Settings manage various aspects of the iterative process,
see \link[multiRL]{control}}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
An S3 object of class \code{DataFrame} containing, for each model, 
 the estimated optimal parameters and associated model fit metrics.
}
\description{
This function provides a unified interface for four estimation methods: 
   Maximum Likelihood Estimation (MLE), Maximum A Posteriori (MAP), 
   Approximate Bayesian Computation (ABC), and Recurrent Neural Network 
   (RNN), allowing users to execute different methods simply by setting 
   \code{estimate = "???"}.
}
