% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mort_soa.R
\name{read_mort_soa}
\alias{read_mort_soa}
\title{Read data from mort.soa.org and return a list of data frames}
\usage{
read_mort_soa(table_id)
}
\arguments{
\item{table_id}{An identification number for a mortality table on
<mort.soa.org>}
}
\value{
A list containing any tables associated with \code{table_id} plus the
metadata attributes described above. Individual tables are data frames
(tibbles).
}
\description{
Read data from mort.soa.org and return a list of data frames
}
\details{
This function first checks if the provided \code{table_id} is available on
mort.soa.org. If not found, an error is returned.

If a match is found, a list containing all tables underneath \code{table_id} is
returned. The list contains several attributes that can be queried using
\verb{attr(\{list\}, "\{attribute\})}. Available attributes include:
\itemize{
\item \code{name} - Name of the table
\item \code{table_id}
\item \code{description} - A detailed description of the table
\item \code{usage} - Intended usage
\item \code{layout} - Table layout
\item \code{nation} - Nation of origin
\item \code{sub_descriptions} - A character vector containing detailed descriptions
for each sub-table underneath \code{table_id}
}

Most tables have either an "Aggregate" or "Select and Ultimate" structure.
\itemize{
\item Aggregate structures contains a single table with one dimension (usually
Age).
\item Select and Ultimate structures contain two tables. The first table contains
two dimensions for Age and Duration. The second table contains a single
dimension for Age.
}

For convenience, any two-dimensional tables are pivoted longer into a "tidy"
format with 3 columns: Age, Duration, and the mortality (or other) rate.
}
\examples{
# Get table #2586: 2012 IAM Period Table – Female, ANB
\donttest{read_mort_soa(2586)}

}
\references{
Society of Actuaries Mortality and Other Rate Tables
\url{https://mort.soa.org}
}
\seealso{
\code{\link[=filter_inventory]{filter_inventory()}}
}
