% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{modsemify}
\alias{modsemify}
\title{Generate parameter table for \code{lavaan} syntax}
\usage{
modsemify(syntax, parentheses.as.string = FALSE)
}
\arguments{
\item{syntax}{model syntax}

\item{parentheses.as.string}{Should parentheses be read parsed as literal strings?}
}
\value{
\code{data.frame} with columns \code{lhs, op, rhs, mod}
}
\description{
Generate parameter table for \code{lavaan} syntax
}
\examples{
library(modsem)
m1 <- '
  # Outer Model
  X =~ x1 + x2 +x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3

  # Inner model
  Y ~ X + Z + X:Z
'
modsemify(m1)
}
