% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAC_spatial.R
\name{spec_sample_curve}
\alias{spec_sample_curve}
\title{Non-spatial and spatially-explicit species sampling curves}
\usage{
spec_sample_curve(comm, method = c("accumulation", "rarefaction"))
}
\arguments{
\item{comm}{Community object}

\item{method}{Partial match to \code{accumulation} or \code{rarefaction}. Also both
methods can be included at the same time.}
}
\value{
A dataframe with 2-3 columns. The first column indicates the sample
size (numbers of individuals), and the second and third column indicate
the expected species richness for spatial sampling (column: "spec_accum")
and/or random sampling (column "spec_rarefied")
}
\description{
Expected species richness as function of sample size (no. of individuals),
when individuals are sampled randomly (rarefaction) or when nearest-neighbours
are samples (accumulation).
}
\details{
Non-spatial sampling corresponds to the species rarefaction curve, which only
depends on the species abundance distribution and can thus be also calculated
from abundance data (see \code{\link{rare_curve}}).

In contrast the species-accumulation curve starts from a focal individual and
only samples the nearest neighbours of the focal individual. The final
species accumulation curves is calculated as the mean over the accumulation
curves starting from all individuals.

In contrast to the rarefaction curve the accumulation curve is not only
influenced by the species abundance distribution, but also by the spatial
distribution of individuals.
}
\examples{
sim_com1 <- sim_thomas_community(s_pool = 100, n_sim = 1000)
sac1 <- spec_sample_curve(sim_com1, method = c("rare","acc"))

head(sac1)
plot(sac1)

}
