% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_targettrafo.R
\name{mlr_graphs_targettrafo}
\alias{mlr_graphs_targettrafo}
\alias{pipeline_targettrafo}
\title{Transform and Re-Transform the Target Variable}
\usage{
pipeline_targettrafo(
  graph,
  trafo_pipeop = PipeOpTargetMutate$new(),
  id_prefix = ""
)
}
\arguments{
\item{graph}{\code{\link{PipeOpLearner}} | \code{\link{Graph}} \cr
A \code{\link{PipeOpLearner}} or \code{\link{Graph}} to wrap between a transformation and re-transformation of the target variable.}

\item{trafo_pipeop}{\code{\link{PipeOp}} \cr
A \code{\link{PipeOp}} that is a subclass of \code{\link{PipeOpTargetTrafo}}. Default is \code{\link{PipeOpTargetMutate}}.}

\item{id_prefix}{\code{character(1)} \cr
Optional id prefix to prepend to \code{\link{PipeOpTargetInvert}} ID. The resulting ID will be \code{"[id_prefix]targetinvert"}. Default is \code{""}.}
}
\value{
\code{\link{Graph}}
}
\description{
Wraps a \code{\link{Graph}} that transforms a target during training and inverts the transformation
during prediction. This is done as follows:
\itemize{
\item Specify a transformation and inversion function using any subclass of \code{\link{PipeOpTargetTrafo}}, defaults to
\code{\link{PipeOpTargetMutate}}, afterwards apply \code{graph}.
\item At the very end, during prediction the transformation is inverted using \code{\link{PipeOpTargetInvert}}.
\item To set a transformation and inversion function for \code{\link{PipeOpTargetMutate}} see the
parameters \code{trafo} and \code{inverter} of the \code{param_set} of the resulting \code{\link{Graph}}.
\item Note that the input \code{graph} is not explicitly checked to actually return a
\code{\link[mlr3:Prediction]{Prediction}} during prediction.
}

All input arguments are cloned and have no references in common with the returned \code{\link{Graph}}.
}
\examples{
\dontshow{if (requireNamespace("rpart")) withAutoprint(\{ # examplesIf}
library("mlr3")

tt = pipeline_targettrafo(PipeOpLearner$new(LearnerRegrRpart$new()))
tt$param_set$values$targetmutate.trafo = function(x) log(x, base = 2)
tt$param_set$values$targetmutate.inverter = function(x) list(response = 2 ^ x$response)

# gives the same as
g = Graph$new()
g$add_pipeop(PipeOpTargetMutate$new(param_vals = list(
  trafo = function(x) log(x, base = 2),
  inverter = function(x) list(response = 2 ^ x$response))
  )
)
g$add_pipeop(LearnerRegrRpart$new())
g$add_pipeop(PipeOpTargetInvert$new())
g$add_edge(src_id = "targetmutate", dst_id = "targetinvert",
  src_channel = 1, dst_channel = 1)
g$add_edge(src_id = "targetmutate", dst_id = "regr.rpart",
  src_channel = 2, dst_channel = 1)
g$add_edge(src_id = "regr.rpart", dst_id = "targetinvert",
  src_channel = 1, dst_channel = 2)
\dontshow{\}) # examplesIf}
}
