% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_acqoptimizers.R
\docType{data}
\name{mlr_acqoptimizers}
\alias{mlr_acqoptimizers}
\title{Dictionary of Acquisition Function Optimizers}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}
\description{
A simple \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} storing objects of class \link{AcqOptimizer}.
Each input transformation has an associated help page, see \code{mlr_acqoptimizers[id]}.

For a more convenient way to retrieve and construct an acquisition function optimizer, see \code{\link[=acqo]{acqo()}}.
}
\section{Methods}{

See \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}

\examples{
library(data.table)
as.data.table(mlr_acqoptimizers)
acqo("local_search")
}
\seealso{
Sugar function: \code{\link[=acqo]{acqo()}}

Other Dictionary: 
\code{\link{mlr_acqfunctions}},
\code{\link{mlr_input_trafos}},
\code{\link{mlr_loop_functions}},
\code{\link{mlr_output_trafos}},
\code{\link{mlr_result_assigners}}
}
\concept{Acquisition Function Optimizer}
\concept{Dictionary}
\keyword{datasets}
