% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorBatchGeneticSearch.R
\name{mlr_fselectors_genetic_search}
\alias{mlr_fselectors_genetic_search}
\alias{FSelectorBatchGeneticSearch}
\title{Feature Selection with Genetic Search}
\description{
Feature selection using the Genetic Algorithm from the package \CRANpkg{genalg}.
}
\section{Dictionary}{

This \link{FSelector} can be instantiated with the associated sugar function \code{\link[=fs]{fs()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fs("genetic_search")
}\if{html}{\out{</div>}}
}

\section{Control Parameters}{

For the meaning of the control parameters, see \code{\link[genalg:rbga.bin]{genalg::rbga.bin()}}.
\code{\link[genalg:rbga.bin]{genalg::rbga.bin()}} internally terminates after \code{iters} iteration.
We set \code{ìters = 100000}  to allow the termination via our terminators.
If more iterations are needed, set \code{ìters} to a higher value in the parameter set.
}

\examples{
\dontshow{if (mlr3misc::require_namespaces("genalg", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Feature Selection
\donttest{

# retrieve task and load learner
task = tsk("penguins")
learner = lrn("classif.rpart")

# run feature selection on the Palmer Penguins data set
instance = fselect(
  fselector = fs("genetic_search"),
  task = task,
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  term_evals = 10
)

# best performing feature set
instance$result

# all evaluated feature sets
as.data.table(instance$archive)

# subset the task and fit the final model
task$select(instance$result_feature_set)
learner$train(task)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other FSelector: 
\code{\link{FSelector}},
\code{\link{mlr_fselectors}},
\code{\link{mlr_fselectors_design_points}},
\code{\link{mlr_fselectors_exhaustive_search}},
\code{\link{mlr_fselectors_random_search}},
\code{\link{mlr_fselectors_rfe}},
\code{\link{mlr_fselectors_rfecv}},
\code{\link{mlr_fselectors_sequential}},
\code{\link{mlr_fselectors_shadow_variable_search}}
}
\concept{FSelector}
\section{Super classes}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{\link[mlr3fselect:FSelectorBatch]{mlr3fselect::FSelectorBatch}} -> \code{FSelectorBatchGeneticSearch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FSelectorBatchGeneticSearch-new}{\code{FSelectorBatchGeneticSearch$new()}}
\item \href{#method-FSelectorBatchGeneticSearch-clone}{\code{FSelectorBatchGeneticSearch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-format'><code>mlr3fselect::FSelector$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="help"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-help'><code>mlr3fselect::FSelector$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-print'><code>mlr3fselect::FSelector$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelectorBatch" data-id="optimize"><a href='../../mlr3fselect/html/FSelectorBatch.html#method-FSelectorBatch-optimize'><code>mlr3fselect::FSelectorBatch$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorBatchGeneticSearch-new"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorBatchGeneticSearch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorBatchGeneticSearch$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorBatchGeneticSearch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorBatchGeneticSearch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorBatchGeneticSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
