% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_quantile.R
\name{weighted.quantile}
\alias{weighted.quantile}
\title{Weighted Sample Quantile}
\usage{
weighted.quantile(
  x,
  w = NULL,
  probs = seq(0, 1, 0.25),
  na.rm = FALSE,
  names = TRUE,
  digits = 7L,
  type = 1L,
  ...
)
}
\arguments{
\item{x}{a numeric vector whose weighted sample quantiles are wanted.}

\item{w}{a numeric vector of the sample weights for each value in \code{x}.}

\item{probs}{a numeric vector of probabilities with values in \code{[0, 1]}.}

\item{na.rm}{logical. If \code{TRUE}, any \code{NA} and \code{NaN}s are removed from \code{x} before the quantiles are computed.}

\item{names}{logical. If \code{TRUE}, the result has a "names" attribute.}

\item{digits}{used only when \code{names} is \code{TRUE}. The precision to use when formatting the percentages.}

\item{type}{an integer between \code{1} and \code{9} selecting the quantile algorithms. Only \code{1} is available for the weighted quantile.}

\item{...}{further arguments passed to \code{stats::quantile()} when weights are not passed.}
}
\value{
\code{weighted.quantile()} returns weighted sample quantiles corresponding to the given probabilities.
}
\description{
\code{weighted.quantile()} produces weighted sample quantiles corresponding to the given probabilities.
}
\details{
\code{weighted.quantile()} is a wrapper function of \code{stats::quantile()} for weighted quantiles.
For the weighted quantile, only the "type 1" quantile, the inverse of the empirical distribution function, is available.
This function is used in \code{numeric.encoder()} to enable weights-based encoding.
}
\seealso{
\code{\link{weighted.tabulate}}
}
\keyword{internal}
