% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhp.R
\docType{package}
\name{mhpfilter-package}
\alias{mhpfilter-package}
\alias{mhpfilter}
\title{mhpfilter: Fast Modified Hodrick-Prescott Filter}
\description{
High-performance implementation of the Modified HP Filter for decomposing
time series into trend and cyclical components. Based on the methodology
of Choudhary, Hanif & Iqbal (2014) which uses generalized cross-validation
to automatically select the optimal smoothing parameter lambda.
}
\details{
The standard Hodrick-Prescott (1997) filter decomposes a time series
\eqn{y_t} into trend \eqn{g_t} and cycle \eqn{c_t} components by minimizing:

\deqn{\sum_{t=1}^{T}(y_t - g_t)^2 + \lambda \sum_{t=1}^{T-2}[(g_{t+2} - g_{t+1}) - (g_{t+1} - g_t)]^2}

where \eqn{\lambda} is the smoothing parameter that controls the trade-off
between trend smoothness and cycle fit.

The Modified HP Filter (McDermott, 1997) selects \eqn{\lambda}
optimally using generalized cross-validation (GCV). The GCV criterion is:

\deqn{GCV(\lambda) = \frac{SSR(\lambda)}{T} \left[ 1 + \frac{2}{T\lambda} \right]}

where \eqn{SSR(\lambda)} is the sum of squared residuals. The optimal
\eqn{\lambda} minimizes this GCV criterion.
}
\section{Main Functions}{

\itemize{
  \item \code{\link{mhp_filter}}: Apply Modified HP filter to single series
  \item \code{\link{hp_filter}}: Apply standard HP filter with fixed lambda
  \item \code{\link{mhp_batch}}: Batch process multiple series efficiently
  \item \code{\link{mhp_compare}}: Compare HP vs Modified HP for single series
  \item \code{\link{batch_compare}}: Compare HP vs Modified HP for multiple series
  \item \code{\link{autoplot.mhp}}: ggplot2 visualization for mhp objects
  \item \code{\link{plot_comparison}}: Compare HP and Modified HP visually
  \item \code{\link{plot_batch}}: Visualize batch processing results
  \item \code{\link{get_lambda}}: Extract optimal lambda from results
  \item \code{\link{get_gcv}}: Extract GCV value from results
}
}

\references{
Choudhary, M.A., Hanif, M.N., & Iqbal, J. (2014). On smoothing macroeconomic
time series using the modified HP filter. \emph{Applied Economics}, 46(19),
2205-2214.

Hodrick, R.J., & Prescott, E.C. (1997). Postwar US business cycles: An
empirical investigation. \emph{Journal of Money, Credit and Banking}, 29(1), 1-16.

McDermott, C.J. (1997). Note on the modified Hodrick-Prescott filter.
\emph{IMF Working Paper No. 97/108}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://myaseen208.com/mhpfilter/}
  \item Report bugs at \url{https://github.com/myaseen208/mhpfilter/issues}
}

}
\author{
\strong{Maintainer}: Muhammad Yaseen \email{myaseen208@gmail.com} (\href{https://orcid.org/0000-0002-5923-1714}{ORCID})

Other contributors:
\itemize{
  \item Javed Iqbal \email{Javed.iqbal6@sbp.org.pk} (Original methodology author) [contributor]
  \item M. Nadim Hanif \email{Nadeem.hanif@sbp.org.pk} (Original methodology author) [contributor]
}

}
