% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ic50s.R
\name{predict_ic50s}
\alias{predict_ic50s}
\title{Predict the half maximal inhibitory concentrations (aka IC50s) (in nM)
of all possible n-mers within a peptide}
\usage{
predict_ic50s(
  protein_sequence,
  peptide_length,
  mhcnuggets_options,
  peptides_path = create_temp_peptides_path()
)
}
\arguments{
\item{protein_sequence}{protein sequence, in uppercase,
for example \code{FAMILYVW}}

\item{peptide_length}{length of a peptide, in number of amino acids}

\item{mhcnuggets_options}{options to run MHCnuggets with,
as can be created by \link{create_mhcnuggets_options}.}

\item{peptides_path}{the path to the peptides}
}
\value{
a tibble with columns:\cr
\itemize{
\item peptide the peptide fragment, each of length \code{peptide_length}
\item ic50 the predicted IC50 (in nM)
}
}
\description{
Predict the half maximal inhibitory concentrations (aka IC50s) (in nM)
of all possible n-mers within a peptide
}
\examples{
if (is_mhcnuggets_installed()) {

  mhcnuggets_options <- create_mhcnuggets_options(
    mhc = "HLA-A02:01"
  )

  predict_ic50s(
    protein_sequence = "AIAACAMLLVCCCCCC",
    peptide_length = 13,
    mhcnuggets_options = mhcnuggets_options
  )
}
}
\author{
Richèl J.C. Bilderbeek
}
