% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mhcnuggets_options.R
\name{create_mhcnuggets_options}
\alias{create_mhcnuggets_options}
\title{Create a set of MHCnuggets options.}
\usage{
create_mhcnuggets_options(
  mhc_class = NA,
  mhc,
  ba_models = FALSE,
  verbose = FALSE,
  folder_name = get_default_mhcnuggets_folder(),
  mhcnuggets_url = get_mhcnuggets_url()
)
}
\arguments{
\item{mhc_class}{MHC class. Must be \code{I}, \code{II}
or \link{NA}. Use \link{NA} to let the class be deduced automatically}

\item{mhc}{the MHC haplotype name}

\item{ba_models}{Set to TRUE to use a pure BA model}

\item{verbose}{set to \link{TRUE} for more debug information}

\item{folder_name}{superfolder of MHCnuggets.
The name of the superfolder is \code{/home/[user_name]/.local/share}
by default, as can be obtained by\link{get_default_mhcnuggets_folder}}

\item{mhcnuggets_url}{URL to the MHCnuggets GitHub repository}
}
\value{
an \code{mhcnuggets_options}
}
\description{
Create a set of options to run MHCnuggets with.
}
\details{
This function will give an error message if the arguments are invalid.
}
\note{
an \code{mhcnuggets_options} created
by \link{create_mhcnuggets_options} is always
checked by \link{check_mhcnuggets_options}
}
\examples{
if (is_mhcnuggets_installed()) {
  create_mhcnuggets_options(
    mhc = "HLA-A02:01"
  )
}
}
\seealso{
use \link{create_test_mhcnuggets_options} to create an
MHCnuggets object for testing
}
\author{
Richèl J.C. Bilderbeek
}
