% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tailindex.R
\name{shape.osz}
\alias{shape.osz}
\title{Extreme U-statistic Pickands estimator}
\usage{
shape.osz(xdat, k, ...)
}
\arguments{
\item{xdat}{vector of observations of length \eqn{n}}

\item{k}{number of largest order statistics \eqn{3 \leq k < n}.}

\item{...}{additional arguments for backward compatibility}
}
\description{
Given a random sample of \code{n} exceedances, the estimator
returns an estimator of the shape parameter or extreme
value index using a kernel of order 3, based on
\code{k} largest exceedances of \code{xdat}. Note that the method does not allow for ties.
}
\details{
The calculations are based on the recursions provided in Lemma 4.3 of Oorschot et al.
}
\examples{
xdat <- rgp(n = 1000, shape = 0.2)
shape.osz(xdat, k = 10)
}
\references{
Oorschot, J, J. Segers and C. Zhou (2023), Tail inference using extreme U-statistics,  Electronic Journal of Statistics 17(1): 1113-1159. \doi{10.1214/23-EJS2129}
}
