% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{summary.dc}
\alias{summary.dc}
\title{Summarise a draws component (dc) object}
\usage{
\method{summary}{dc}(
  object,
  probs = c(0.05, 0.5, 0.95),
  na.rm = FALSE,
  time = NULL,
  abbr = FALSE,
  batch.size = 100L,
  ...
)
}
\arguments{
\item{object}{an object of class \code{dc}.}

\item{probs}{vector of probabilities at which to evaluate quantiles.}

\item{na.rm}{whether to remove NA/NaN draws in computing the summaries.}

\item{time}{MCMC computation time; if specified the effective sample size per unit of time
is returned in an extra column labelled 'efficiency'.}

\item{abbr}{if \code{TRUE} abbreviate the labels in the output.}

\item{batch.size}{number of parameter columns to process simultaneously. A larger batch size may speed things up a little,
but if an out of memory error occurs it may be a good idea to use a smaller number and try again. The default is 100.}

\item{...}{arguments passed to \code{\link{n_eff}}.}
}
\value{
A matrix with summaries of class \code{dc_summary}.
}
\description{
Summarise a draws component (dc) object
}
\examples{
\donttest{
ex <- mcmcsae_example()
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, store.all=TRUE)
summary(sim$u)
}

}
