% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{MCMC-diagnostics}
\alias{MCMC-diagnostics}
\alias{R_hat}
\alias{n_eff}
\title{Compute MCMC diagnostic measures}
\usage{
R_hat(dc)

n_eff(dc, useFFT = TRUE, lag.max, cl = NULL)
}
\arguments{
\item{dc}{a draws component (dc) object corresponding to a model parameter.}

\item{useFFT}{whether to use the Fast Fourier Transform algorithm. Default is \code{TRUE} as this is typically faster.}

\item{lag.max}{the lag up to which autocorrelations are computed in case \code{useFFT=FALSE}.}

\item{cl}{a cluster for parallel computation.}
}
\value{
In case of \code{R_hat} the split R-hat convergence diagnostic for each
 component of the vector parameter, and in case of \code{n_eff} the effective
 number of independent samples for each component of the vector parameter.
}
\description{
\code{R_hat} computes Gelman-Rubin convergence diagnostics based on the MCMC output
in a model component, and \code{n_eff} computes the effective sample sizes, .i.e.
estimates for the number of independent samples from the posterior distribution.
}
\examples{
\donttest{
ex <- mcmcsae_example()
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, burnin=100, n.iter=300, thin=2, n.chain=4, store.all=TRUE)
n_eff(sim$beta)
n_eff(sim$v_sigma)
n_eff(sim$v_rho)
R_hat(sim$beta)
R_hat(sim$llh_)
R_hat(sim$v_sigma)
}

}
\references{
A. Gelman and D. B. Rubin (1992).
   Inference from Iterative Simulation Using Multiple Sequences.
   Statistical Science 7, 457-511.

 A. Gelman, J.B. Carlin, H.S. Stern, D.B. Dunson, A. Vehtari and D.B. Rubin (2013).
   Bayesian Data Analysis, 3rd edition.
   Chapman & Hall/CRC.
}
