% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_exp.R
\name{cor_exp}
\alias{cor_exp}
\title{Calculate exponential correlation}
\usage{
cor_exp(x, c, gamma = 1/2, nugget = 0, is.dist = FALSE)
}
\arguments{
\item{x}{A numeric vector, matrix, or array.}

\item{c}{Smooth parameter, \eqn{c>0}.}

\item{gamma}{Scale parameter, \eqn{\gamma\in(0, 1/2]}. Default is 1/2.}

\item{nugget}{The nugget effect \eqn{\in[0, 1]}.}

\item{is.dist}{Logical; if TRUE, \code{x} is a distance matrix or an array of
distance matrices.}
}
\value{
Correlations of the same dimension as \code{x}.
}
\description{
Calculate exponential correlation
}
\details{
The exponential correlation function with scale parameter \eqn{c}
and smooth parameter \eqn{\gamma} has the form
\deqn{C(x)=(1-\text{nugget})\exp(-c|x|^{2\gamma})+\text{nugget}\cdot
\delta_{x=0},} where \eqn{\delta_{x=0}} is 1 when \eqn{x=0} and 0 otherwise.
}
\examples{
x <- matrix(c(0, 5, 5, 0), nrow = 2)
cor_exp(x, c = 0.01, gamma = 0.5)

x <- matrix(c(0, 5, 5, 0), nrow = 2)
cor_exp(x, c = 0.01, gamma = 0.5, nugget = 0.3, is.dist = TRUE)

}
\references{
Diggle, P. J., Tawn, J. A., & Moyeed, R. A. (1998). Model-Based
Geostatistics. Journal of the Royal Statistical Society. Series C (Applied
Statistics), 47(3), 299–350.
}
\seealso{
Other correlation functions: 
\code{\link{cor_cauchy}()},
\code{\link{cor_fs}()},
\code{\link{cor_lagr_askey}()},
\code{\link{cor_lagr_exp}()},
\code{\link{cor_lagr_tri}()},
\code{\link{cor_sep}()},
\code{\link{cor_stat}()},
\code{\link{cor_stat_rs}()}
}
\concept{correlation functions}
