% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_med_mod_ab1}
\alias{data_med_mod_ab1}
\title{Sample Dataset: Simple
Mediation with Both Paths Moderated
By a Moderator}
\format{
A data frame with 100 rows
and 6 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{w}{Moderator. Numeric.}
\item{m}{Mediator. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_med_mod_ab1
}
\description{
A simple mediation model
with a-path and b-path moderated by
one moderator.
}
\examples{
library(lavaan)
data(data_med_mod_ab1)
data_med_mod_ab1$xw <-
 data_med_mod_ab1$x *
 data_med_mod_ab1$w
data_med_mod_ab1$mw <-
 data_med_mod_ab1$m *
 data_med_mod_ab1$w
mod <-
"
m ~ a * x + w + da * xw + c1 + c2
y ~ b * m + x + w + db * mw + c1 + c2
w ~~ v_w * w
w ~ m_w * 1
ab := a * b
ab_lo := (a + da * (m_w - sqrt(v_w))) * (b + db * (m_w - sqrt(v_w)))
ab_hi := (a + da * (m_w + sqrt(v_w))) * (b + db * (m_w + sqrt(v_w)))
"
fit <- sem(mod, data_med_mod_ab1,
           meanstructure = TRUE, fixed.x = FALSE)
parameterEstimates(fit)[c(1, 3, 6, 9, 38:40), ]
}
\keyword{datasets}
