% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_system_registry.R
\name{PlotSystemRegistry}
\alias{PlotSystemRegistry}
\title{Plot System Registry}
\format{
An R6 class
}
\description{
Central registry for managing different plotting systems and their adapters.
This registry allows dynamic registration and discovery of plotting systems
and their associated adapters and processor factories.
}
\keyword{Processor}
\keyword{Register}
\keyword{Registered}
\keyword{System}
\keyword{a}
\keyword{adapters}
\keyword{factories}
\keyword{internal}
\keyword{new}
\keyword{plotting}
\keyword{system}
\keyword{systems}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PlotSystemRegistry-register_system}{\code{PlotSystemRegistry$register_system()}}
\item \href{#method-PlotSystemRegistry-detect_system}{\code{PlotSystemRegistry$detect_system()}}
\item \href{#method-PlotSystemRegistry-get_adapter}{\code{PlotSystemRegistry$get_adapter()}}
\item \href{#method-PlotSystemRegistry-get_processor_factory}{\code{PlotSystemRegistry$get_processor_factory()}}
\item \href{#method-PlotSystemRegistry-get_adapter_for_plot}{\code{PlotSystemRegistry$get_adapter_for_plot()}}
\item \href{#method-PlotSystemRegistry-get_processor_factory_for_plot}{\code{PlotSystemRegistry$get_processor_factory_for_plot()}}
\item \href{#method-PlotSystemRegistry-list_systems}{\code{PlotSystemRegistry$list_systems()}}
\item \href{#method-PlotSystemRegistry-is_system_registered}{\code{PlotSystemRegistry$is_system_registered()}}
\item \href{#method-PlotSystemRegistry-unregister_system}{\code{PlotSystemRegistry$unregister_system()}}
\item \href{#method-PlotSystemRegistry-clone}{\code{PlotSystemRegistry$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlotSystemRegistry-register_system"></a>}}
\if{latex}{\out{\hypertarget{method-PlotSystemRegistry-register_system}{}}}
\subsection{Method \code{register_system()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlotSystemRegistry$register_system(system_name, adapter, processor_factory)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{system_name}}{Name of the plotting system (e.g., "ggplot2", "base_r")}

\item{\code{adapter}}{Adapter instance for this system}

\item{\code{processor_factory}}{Processor factory instance for this system
Detect which system can handle a plot object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlotSystemRegistry-detect_system"></a>}}
\if{latex}{\out{\hypertarget{method-PlotSystemRegistry-detect_system}{}}}
\subsection{Method \code{detect_system()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlotSystemRegistry$detect_system(plot_object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_object}}{The plot object to check}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
System name if found, NULL otherwise
Get the adapter for a specific system
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlotSystemRegistry-get_adapter"></a>}}
\if{latex}{\out{\hypertarget{method-PlotSystemRegistry-get_adapter}{}}}
\subsection{Method \code{get_adapter()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlotSystemRegistry$get_adapter(system_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{system_name}}{Name of the system}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Adapter instance
Get the processor factory for a specific system
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlotSystemRegistry-get_processor_factory"></a>}}
\if{latex}{\out{\hypertarget{method-PlotSystemRegistry-get_processor_factory}{}}}
\subsection{Method \code{get_processor_factory()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlotSystemRegistry$get_processor_factory(system_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{system_name}}{Name of the system}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Processor factory instance
Get the adapter for a plot object (auto-detect system)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlotSystemRegistry-get_adapter_for_plot"></a>}}
\if{latex}{\out{\hypertarget{method-PlotSystemRegistry-get_adapter_for_plot}{}}}
\subsection{Method \code{get_adapter_for_plot()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlotSystemRegistry$get_adapter_for_plot(plot_object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_object}}{The plot object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Adapter instance
Get the processor factory for a plot object (auto-detect system)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlotSystemRegistry-get_processor_factory_for_plot"></a>}}
\if{latex}{\out{\hypertarget{method-PlotSystemRegistry-get_processor_factory_for_plot}{}}}
\subsection{Method \code{get_processor_factory_for_plot()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlotSystemRegistry$get_processor_factory_for_plot(plot_object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_object}}{The plot object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Processor factory instance
List all registered systems
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlotSystemRegistry-list_systems"></a>}}
\if{latex}{\out{\hypertarget{method-PlotSystemRegistry-list_systems}{}}}
\subsection{Method \code{list_systems()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlotSystemRegistry$list_systems()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of registered system names
Check if a system is registered
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlotSystemRegistry-is_system_registered"></a>}}
\if{latex}{\out{\hypertarget{method-PlotSystemRegistry-is_system_registered}{}}}
\subsection{Method \code{is_system_registered()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlotSystemRegistry$is_system_registered(system_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{system_name}}{Name of the system}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if registered, FALSE otherwise
Unregister a system
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlotSystemRegistry-unregister_system"></a>}}
\if{latex}{\out{\hypertarget{method-PlotSystemRegistry-unregister_system}{}}}
\subsection{Method \code{unregister_system()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlotSystemRegistry$unregister_system(system_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{system_name}}{Name of the system to unregister}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlotSystemRegistry-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PlotSystemRegistry-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlotSystemRegistry$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
