% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lua_mode.R
\name{lua_mode}
\alias{lua_mode}
\title{Debugger, profiler, and JIT options}
\usage{
lua_mode(expr, debug, profile, jit)
}
\arguments{
\item{expr}{An expression to run with the associated settings. If \code{expr} is
present, the settings apply only while \code{expr} is being evaluated. If \code{expr}
is missing, the settings apply until they are changed by another call to
\code{\link[=lua_mode]{lua_mode()}}.}

\item{debug}{Control the debugger: \code{"step"} / \code{"on"} / \code{TRUE} to step
through each line; \code{"error"} to trigger the debugger on a Lua error;
\code{"off"} / \code{FALSE} to switch the debugger off.}

\item{profile}{Control the profiler: \code{"on"} / \code{TRUE} to use the profiler's
default settings; a specially formatted string (see below) to control the
profiler's precision and sampling interval; \code{"off"} / \code{FALSE} to switch the
profiler off.}

\item{jit}{Control LuaJIT's just-in-time compiler: \code{"on"} / \code{TRUE} to use
the JIT, \code{"off"} / \code{FALSE} to use the LuaJIT interpreter only.}
}
\value{
When called with no arguments, returns the current settings. When
called with \code{expr}, calls the value returned by \code{expr}. Otherwise, returns
nothing.
}
\description{
Run Lua code with the debugger or profiler activated, and control whether
the LuaJIT just-in-time compiler is on.
}
\section{Details}{
This function is experimental. Its interface and behaviour may change in
subsequent versions of luajr.

\code{\link[=lua_mode]{lua_mode()}} works in one of three ways, depending on which parameters are
provided.

When called with no arguments, \code{\link[=lua_mode]{lua_mode()}} returns the current \code{debug},
\code{profile}, and \code{jit} settings.

When called without an \code{expr} argument, but with at least one of \code{debug},
\code{profile}, or \code{jit}, the specified settings apply for any subsequent
executions of Lua code until the next call to \code{\link[=lua_mode]{lua_mode()}}.

When called with an \code{expr} argument, the specified settings for \code{debug},
\code{profile}, and \code{jit} are applied temporarily just for the evaluation of
\code{expr} in the calling frame.

Note that if you provide some but not all of the \code{debug}, \code{profile}, and
\code{jit} arguments, the "missing" settings are retained at their current
values, not reset to some default or "off" state. In other words, you can
temporarily change one setting without affecting the others.
}

\section{The debugger}{
The \code{debug} setting allows you to run Lua code in debug mode, using Scott
Lembcke's \href{https://github.com/slembcke/debugger.lua}{\code{debugger.lua}}.

Use \code{debug = "step"} (or \code{TRUE} or "on") to step through each line of the
code; use \code{debug = "error"} to trigger the debugger on any Lua error; and
turn off the debugger with \code{debug = "off"} (or \code{FALSE}).

To trigger the debugger from a specific place within your Lua code, you can
also call \code{luajr.dbg()} from your Lua code. Within Lua, you can also use
\code{luajr.dbg(CONDITION)} to trigger debugging only if \code{CONDITION} evaluates to
\code{false} or \code{nil}. (In this way, \code{luajr.dbg(CONDITION)} is sort of like an
\code{assert(CONDITION)} call that triggers the debugger when the assert fails.)

\code{debugger.lua} is more fully documented at its
\href{https://github.com/slembcke/debugger.lua}{github repo page}, but briefly,
you enter commands of one character at the \verb{debugger.lua>} prompt. Use
\code{n} to step to the next line, \code{q} to quit, and \code{h} to show a help page with
all the rest of the commands.
}

\section{The profiler}{
The \code{profile} setting allows you to profile your Lua code run, generating
information useful for optimising its execution speed.

Use \code{profile = "on"} (or \code{TRUE}) to turn on the profiler with default
settings (namely, profile at the line level and sample at 1-millisecond
intervals).

Instead of \code{"on"}, you can pass a string containing any of these options:
\itemize{
\item \code{f}: enable profiling to the function level.
\item \code{l}: enable profiling to the line level.
\item \verb{i<integer>}: set the sampling interval, in milliseconds (default: 1ms).
}

For example, the default options correspond to the string \code{"li1"}.

You must use \code{\link[=lua_profile]{lua_profile()}} to recover the generated profiling data.
}

\section{JIT options}{
The \code{jit} setting allows you to turn LuaJIT's just-in-time compiler off
(with \code{jit = "off"} or \code{FALSE}). The default is for the JIT compiler to be
\code{"on"} (alias \code{TRUE}).

Lua code will generally run more slowly with the JIT off, although there
have been issues reported with LuaJIT running more slowly with the JIT on
for processors using ARM64 architecture, which includes Apple Silicon CPUs.
}

\examples{
\dontrun{
# Debugger in "one-shot" mode
lua_mode(debug = "on",
    sum <- lua("
        local s = 0
        for i = 1,10 do
            s = s + i
        end
        return s
    ")
)

# Profiler in "switch on / switch off" mode
lua_mode(profile = TRUE)
pointless_computation = lua_func(
"function()
    local s = startval
    for i = 1,10^8 do
        s = math.sin(s)
        s = math.exp(s^2)
        s = s + 1
    end
    return s
end")
lua("startval = 100")
pointless_computation()
lua_mode(profile = FALSE)
lua_profile()

# Turn off JIT and turn it on again
lua_mode(jit = "off")
lua_mode(jit = "on")
}
}
\seealso{
\code{\link[=lua_profile]{lua_profile()}} for extracting the generated profiling data.
}
