% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lotriMatInv.R
\name{lotriMatInv}
\alias{lotriMatInv}
\title{Converts a matrix into a list of block matrices}
\usage{
lotriMatInv(mat)
}
\arguments{
\item{mat}{Matrix to convert to a list of block matrices}
}
\value{
A list of block matrixes
}
\description{
Converts a matrix into a list of block matrices
}
\details{
This is the inverse of `lotriMat()`
}
\examples{

# Create a block matrix using `lotri()`
mat <- lotri({
   a+b ~ c(1,
           0.5, 1)
   c ~ 1
   d +e ~ c(1,
            0.5, 1)
})

print(mat)

# now convert t a list of matrices

mat2 <- lotriMatInv(mat)
print(mat2)

# Of course you can convert it back to a full matrix:

mat3 <- lotriMat(mat2)

print(mat3)
}
\author{
Matthew Fidler
}
