% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/si.R
\name{si}
\alias{si}
\title{Calculate Serial Interval Distribution for COVID-19}
\usage{
si(ndays, alpha, beta)
}
\arguments{
\item{ndays}{Integer, the number of days over which to calculate the serial interval distribution.}

\item{alpha}{Numeric, the shape parameter of the gamma distribution.}

\item{beta}{Numeric, the rate parameter of the gamma distribution.}
}
\value{
Numeric vector representing the serial interval probabilities for each of the first `ndays` days.
        The probabilities are normalized so that their sum is 1.
}
\description{
This function computes the probability distribution function (PDF) of the serial interval for COVID-19
using a gamma distribution with specified shape and rate parameters. The serial interval is defined
as the time between successive cases in a chain of transmission. This implementation generates a discrete
PDF over a given number of days.
}
\details{
The function uses the `pgamma` function to calculate cumulative probabilities for each day up to `ndays`
and then differences these to get daily probabilities. The resulting probabilities are normalized to sum to 1,
ensuring that they represent a valid probability distribution.
}
\examples{
sip <- si(14, 4.29, 1.18)
}
\references{
Nishiura, H., Linton, N. M., & Akhmetzhanov, A. R. (2020). Serial interval of novel coronavirus (COVID-19) infections.
International Journal of Infectious Diseases, 93, 284-286.
[Link to the article](https://www.sciencedirect.com/science/article/pii/S1201971220306111)
}
