% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-fisherian.R
\name{profile_loglik}
\alias{profile_loglik}
\alias{profile_loglik.fisher_mle}
\title{Profile Log-Likelihood}
\usage{
profile_loglik(x, ...)

\method{profile_loglik}{fisher_mle}(
  x,
  data,
  model,
  param,
  grid = NULL,
  n_grid = 50,
  range_mult = 4,
  ...
)
}
\arguments{
\item{x}{A fisher_mle object}

\item{...}{Additional arguments passed to loglik}

\item{data}{Data frame used for likelihood computation}

\item{model}{The likelihood model used for fitting}

\item{param}{Index or name of parameter(s) to profile}

\item{grid}{Optional grid of values to evaluate (vector or matrix)}

\item{n_grid}{Number of grid points if grid not specified (default 50)}

\item{range_mult}{Multiplier for grid range based on SE (default 4)}
}
\value{
A data frame with parameter values and profile log-likelihood
}
\description{
Computes the profile log-likelihood for a subset of parameters.
For each value of the parameters of interest, the remaining
(nuisance) parameters are optimized out.
}
\details{
The profile likelihood is useful for:
\itemize{
\item Visualizing the likelihood surface
\item Computing likelihood intervals
\item Eliminating nuisance parameters
}
}
