# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# coffee_poly

library(testthat)

# Test 1: Confirm the object is a tibble and a data.frame
test_that("coffee_poly is a tibble and a data.frame", {
  expect_s3_class(coffee_poly, "tbl_df")
  expect_s3_class(coffee_poly, "data.frame")
})

# Test 2: Confirm it has exactly 3 columns
test_that("coffee_poly has 3 columns", {
  expect_equal(length(coffee_poly), 3)
})

# Test 3: Confirm it has exactly 47 rows
test_that("coffee_poly has 47 rows", {
  expect_equal(nrow(coffee_poly), 47)
})

# Test 4: Confirm column names are correct
test_that("coffee_poly has correct column names", {
  expect_named(coffee_poly, c(
    "name_long", "coffee_production_2016", "coffee_production_2017"
  ))
})

# Test 5: Confirm column types are as expected
test_that("coffee_poly columns have correct types", {
  expect_type(coffee_poly$name_long, "character")
  expect_type(coffee_poly$coffee_production_2016, "integer")
  expect_type(coffee_poly$coffee_production_2017, "integer")
})
