% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{cyclehire_pts}
\alias{cyclehire_pts}
\title{Cycle Hire Stations in London}
\format{
An \code{sf} object with 742 observations and 6 variables:
\describe{
  \item{id}{Station identifier (integer)}
  \item{name}{Name of the station (factor)}
  \item{area}{Area of London where the station is located (factor with 121 levels)}
  \item{nbikes}{Number of bikes available (integer)}
  \item{nempty}{Number of empty docking slots (integer)}
  \item{geometry}{Point geometry in XY coordinates (\code{sfc_POINT})}
}
}
\source{
Data taken from the \pkg{spData} package version 2.3.4
}
\usage{
data(cyclehire_pts)
}
\description{
This dataset, \code{cyclehire_pts}, is an \code{sf} object containing point locations
of cycle hire stations across London. Each observation represents a hire point with
information about its name, area, number of available bikes, and number of empty
docking slots at the time of data collection.
}
\details{
The dataset name has been kept as \code{cyclehire_pts} to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
\code{lightsf} package and assists users in identifying its specific characteristics.
The suffix \code{pts} indicates that the dataset contains point geometries.
The original content has not been modified in any way.
}
