% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/klfda.R
\name{klfda}
\alias{klfda}
\title{Kernel Local Fisher Discriminant Analysis for
Supervised Dimensionality Reduction}
\usage{
klfda(k, y, r, metric = c("weighted", "orthonormalized", "plain"),
  knn = 6, reg = 0.001)
}
\arguments{
\item{k}{n x n kernel matrix. Result of the \code{\link{kmatrixGauss}} function.
n is the number of samples}

\item{y}{n dimensional vector of class labels}

\item{r}{dimensionality of reduced space (default: d)}

\item{metric}{type of metric in the embedding space (default: 'weighted')
'weighted'        --- weighted eigenvectors
'orthonormalized' --- orthonormalized
'plain'           --- raw eigenvectors}

\item{knn}{parameter used in local scaling method (default: 6)}

\item{reg}{regularization parameter (default: 0.001)}
}
\value{
list of the LFDA results:
\item{T}{d x r transformation matrix (Z = t(T) * X)}
\item{Z}{r x n matrix of dimensionality reduced samples}
}
\description{
Performs kernel local fisher discriminant analysis on the given data,
which is the non-linear version of LFDA (see details \code{\link{lfda}}).
}
\examples{

k <- kmatrixGauss(iris[, -5])
y <- iris[, 5]
r <- 3
klfda(k, y, r, metric = "plain")
}
\references{
Sugiyama, M (2007). - contain implementation
Dimensionality reduction of multimodal labeled data by
local Fisher discriminant analysis.
\emph{Journal of Machine Learning Research}, vol.\bold{8}, 1027--1061.

Sugiyama, M (2006).
Local Fisher discriminant analysis for supervised dimensionality reduction.
In W. W. Cohen and A. Moore (Eds.), \emph{Proceedings of 23rd International
Conference on Machine Learning (ICML2006)}, 905--912.

Original Matlab Implementation: http://www.ms.k.u-tokyo.ac.jp/software.html#LFDA
}
\seealso{
See \code{\link{lfda}} for the linear version.
}
\author{
Yuan Tang
}
\keyword{discriminant}
\keyword{fisher}
\keyword{klfda}
\keyword{local}
\keyword{mahalanobis}
\keyword{metric}
\keyword{transformation}
