% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateKlass-graph-navigate.R
\name{klass_node}
\alias{klass_node}
\title{Given a Klass graph, find the node corresponding to a code and (optionally) a
date.}
\usage{
klass_node(graph, x, date = NA)
}
\arguments{
\item{graph}{A graph generated by \code{\link{klass_graph}}.}

\item{x}{The code to search for.}

\item{date}{Optional. The specific date the supplied code is valid in.}
}
\value{
The node in the graph corresponding to the supplied code. If date is
  not provided, the node with the most recent code is returned. If date is
  provided, the code with date between \code{validFrom} and \code{validTo} is
  returned.
}
\description{
Given a Klass graph, find the node corresponding to a code and (optionally) a
date.
}
\examples{
\dontrun{
# Build a graph directed towards the most recent codes.
library(klassR)
klass_131 <- klass_graph(131)

# Find the most recent node in the graph representing the code "0101" (Halden,
# valid to 2020.)
halden_node <- klass_node(klass_131, "0101")
}
}
