% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata-filter.R
\name{metadata-filter}
\alias{metadata-filter}
\alias{metadata_filter}
\alias{\%.eq\%}
\alias{\%.ieq\%}
\alias{\%.~eq\%}
\alias{\%.ne\%}
\alias{\%.Like\%}
\alias{\%.~Like\%}
\alias{\%.^Like\%}
\alias{\%.~^Like\%}
\alias{\%.Like$\%}
\alias{\%.~Like$\%}
\alias{\%.like\%}
\alias{\%.~like\%}
\alias{\%.^like\%}
\alias{\%.~^like\%}
\alias{\%.like$\%}
\alias{\%.~like$\%}
\alias{\%.gt\%}
\alias{\%.ge\%}
\alias{\%.lt\%}
\alias{\%.le\%}
\alias{\%.token\%}
\alias{\%.~token\%}
\alias{\%.in\%}
\alias{\%.~in\%}
\title{Metadata Filter}
\usage{
metadata_filter(property, operator, values, call = caller_env())

property \%.eq\% values

property \%.ieq\% values

property \%.~eq\% values

property \%.ne\% values

property \%.Like\% values

property \%.~Like\% values

property \%.^Like\% values

property \%.~^Like\% values

property \%.Like$\% values

property \%.~Like$\% values

property \%.like\% values

property \%.~like\% values

property \%.^like\% values

property \%.~^like\% values

property \%.like$\% values

property \%.~like$\% values

property \%.gt\% values

property \%.ge\% values

property \%.lt\% values

property \%.le\% values

property \%.token\% values

property \%.~token\% values

property \%.in\% values

property \%.~in\% values
}
\arguments{
\item{property}{The property on the metadata you want to filter on}

\item{operator}{The comparison operator you want to perform}

\item{values}{The value to check against}

\item{call}{description}
}
\value{
A spliced list with filter in the format property:operator:value
}
\description{
Formats a metadata filter to DHIS 2 comparison operators.
}
\details{
To filter the metadata there are several filter operations that can be applied
to the returned list of metadata. The format of the filter itself is
straight-forward and follows the pattern property:operator:value, where
property is the property on the metadata you want to filter on, operator is
the comparison operator you want to perform and value is the value to check
against (not all operators require value). To view the operator see
\href{https://docs.dhis2.org/en/develop/using-the-api/dhis-core-version-master/metadata.html#webapi_metadata_object_filter}{DHIS 2 Operator}
\itemize{
\item \verb{\%.eq\%}        - Equality
\item \verb{\%.ieq\%}       - Case insensitive string, match exact
\item \verb{\%.~eq\%}       - Inequality
\item \verb{\%.ne\%}        - Inequality
\item \verb{\%.Like\%}      - Case sensitive string, match anywhere
\item \verb{\%.~Like\%}     - Case sensitive string, not match anywhere
\item \verb{\%.^Like\%}     - Case sensitive string, match start
\item \verb{\%.~^Like\%}    - Case sensitive string, not match start
\item \verb{\%.Like$\%}     - Case sensitive string, match end
\item \verb{\%.~Like$\%}    - Case sensitive string, not match end
\item \verb{\%.like\%}      - Case insensitive string, match anywhere
\item \verb{\%.~like\%}     - Case insensitive string, not match anywhere
\item \verb{ \%.^like\%}    - Case insensitive string, match start
\item \verb{\%.~^like\%}    - Case insensitive string, not match start
\item \verb{\%.like$\%}     - Case insensitive string, match end
\item \verb{\%.~like$\%}    - Case insensitive string, not match end
\item \verb{\%.gt\%}        - Greater than
\item \verb{\%.ge\%}        - Greater than or equal
\item \verb{\%.lt\%}        - Less than
\item \verb{\%.le\%}        - Less than or equal
\item \verb{\%.token\%}     - Match on multiple tokens in search property
\item \verb{\%.~token\%}    - Not match on multiple tokens in search property
\item \verb{\%.in\%}        - Find objects matching 1 or more values
\item \verb{\%.~in\%}       - Find objects not matching 1 or more values
}
}
\examples{

# Generate an equality filter
id \%.eq\% 'element_id'

# Finding multiple ids
'id' \%.in\% c('id1', 'id2', 'id3')

# Get all data elements which have a data set with id ID1
'dataSetElements.dataSet.id' \%.eq\% 'ID1'

# get data elements which are members of the ANC data element group
'dataElementGroups.id' \%.eq\% 'qfxEYY9xAl6'

# Get data elements which have any option set
metadata_filter('optionSet', '!null', NULL)

}
