% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_in_top_k}
\alias{k_in_top_k}
\title{Returns whether the \code{targets} are in the top \code{k} \code{predictions}.}
\usage{
k_in_top_k(predictions, targets, k)
}
\arguments{
\item{predictions}{A tensor of shape \verb{(batch_size, classes)} and type
\code{float32}.}

\item{targets}{A 1D tensor of length \code{batch_size} and type \code{int32} or
\code{int64}.}

\item{k}{An \code{int}, number of top elements to consider.}
}
\value{
A 1D tensor of length \code{batch_size} and type \code{bool}. \code{output[[i]]} is
\code{TRUE} if \verb{predictions[i, targets[[i]]} is within top-\code{k} values of
\code{predictions[[i]]}.
}
\description{
Returns whether the \code{targets} are in the top \code{k} \code{predictions}.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://tensorflow.rstudio.com/reference/keras/index.html#backend}.
}

