% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R, R/package.R
\name{install_keras}
\alias{install_keras}
\alias{py_require_legacy_keras}
\title{Install TensorFlow and Legacy Keras, including all Python dependencies}
\usage{
install_keras(
  method = c("auto", "virtualenv", "conda"),
  conda = "auto",
  version = "default",
  tensorflow = version,
  extra_packages = NULL,
  ...
)

py_require_legacy_keras(extra_packages = TRUE)
}
\arguments{
\item{method}{Installation method. By default, "auto" automatically finds a
method that will work in the local environment. Change the default to force
a specific installation method. Note that the "virtualenv" method is not
available on Windows.}

\item{conda}{The path to a \code{conda} executable. Use \code{"auto"} to allow
\code{reticulate} to automatically find an appropriate \code{conda} binary.
See \strong{Finding Conda} and \code{\link[reticulate:conda_binary]{conda_binary()}} for more details.}

\item{version}{TensorFlow version to install. Valid values include:
\itemize{
\item \code{"default"} installs  2.20
\item \code{"release"} installs the latest release version of tensorflow (which may
be incompatible with the current version of the R package)
\item A version specification like \code{"2.4"} or \code{"2.4.0"}. Note that if the patch
version is not supplied, the latest patch release is installed (e.g.,
\code{"2.4"} today installs version "2.4.2")
\item \code{nightly} for the latest available nightly build.
\item To any specification, you can append "-cpu" to install the cpu version
only of the package (e.g., \code{"2.4-cpu"})
\item The full URL or path to a installer binary or python *.whl file.
}}

\item{tensorflow}{Synonym for \code{version}. Maintained for backwards.}

\item{extra_packages}{Additional Python packages to install along with
TensorFlow.}

\item{...}{other arguments passed to \code{\link[reticulate:conda-tools]{reticulate::conda_install()}} or
\code{\link[reticulate:virtualenv-tools]{reticulate::virtualenv_install()}}, depending on the \code{method} used.}
}
\description{
This function can be used to create a persistent virtual environment for usage
with Legacy Keras. New code is recommended to use the \code{keras3} package which
works automatically and does any special configuration like this.
}
\details{
Note that recent versions of reticulate will automatically manage
environments if dependencies are declared with \code{reticulate::py_require()}.
Instead of using this \code{install_keras()} function, new users are first
encouraged to use \code{keras3}. If that's not an option, instead of creating a
persistent venv, you can this code at the start of the R session, before
loading keras:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# declare requirements for legacy keras (tf-keras)
reticulate::py_require(c("tensorflow", "tf-keras", "numpy<2"))

# also declare optional dependencies
reticulate::py_require(c(
  "tensorflow-hub", "tensorflow-datasets", "scipy",
  "requests", "Pillow", "h5py", "pandas", "pydot"
))
library(keras)
}\if{html}{\out{</div>}}

Or more simply, call \code{py_require_legacy_keras()}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(keras)
py_require_legacy_keras()
}\if{html}{\out{</div>}}

This function will install Tensorflow and all Keras dependencies. This is a
thin wrapper around \code{\link[tensorflow:install_tensorflow]{tensorflow::install_tensorflow()}}, with the only
difference being that this includes by default additional extra packages that
keras expects, and the default version of tensorflow installed by
\code{install_keras()} may at times be different from the default installed
\code{install_tensorflow()}. The default version of tensorflow installed by
\code{install_keras()} is "2.15".

The default additional packages are:
tensorflow-hub, tensorflow-datasets, scipy, requests, pyyaml, Pillow, h5py, pandas, pydot, with their
versions potentially constrained for compatibility with the
requested tensorflow version.
}
\seealso{
\code{\link[tensorflow:install_tensorflow]{tensorflow::install_tensorflow()}}
}
