% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryBuilder.R
\name{updateQueryBuilder}
\alias{updateQueryBuilder}
\title{updateQueryBuilder}
\usage{
updateQueryBuilder(
  inputId,
  setFilters = NULL,
  addFilter = NULL,
  setRules = NULL,
  destroy = FALSE,
  reset = FALSE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{inputId of builder to update.}

\item{setFilters}{list of lists container new filters.}

\item{addFilter}{Named list containing \code{filter} and \code{position} elements.
\code{filter} should be a list contianing a list which has the new filter to add.
\code{position} can be a string of either "start" or "end" or a integer specifying the position
to insert the rule. If position if ommited, filter will be inserted at the end.}

\item{setRules}{List of rules apply to the builder.}

\item{destroy}{bool. \code{TRUE} to destory filter.}

\item{reset}{bool. \code{TRUE} to reset filter.}

\item{session}{The session object passed to function given
to shinyServer. Default is getDefaultReactiveDomain().}
}
\value{
An updated \code{\link[=queryBuilderInput]{queryBuilderInput()}}
}
\description{
Update a queryBuilder with available methods.
}
\examples{
library(shiny)
library(jqbr)

# Button to reset the build an remove all rules
ui <- fluidPage(
  useQueryBuilder(),
  queryBuilderInput(
    inputId = "qb",
    filters = list(
      list(
        id = "name",
        type = "string"
      )
    )
  ),
  actionButton("reset", "Reset")
)

server <- function(input, output) {
  observeEvent(input$reset, {
    updateQueryBuilder(
      inputId = "qb",
      reset = TRUE
    )
  })
}

if (interactive()) {
  shinyApp(ui, server)
}
}
