% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_na_vals.R
\name{update_na_values}
\alias{update_na_values}
\title{Update NA and/or values}
\usage{
update_na_values(
  dt,
  var,
  reportvar = getOption("joyn.reportvar"),
  suffixes = getOption("joyn.suffixes"),
  rep_NAs = FALSE,
  rep_values = FALSE
)
}
\arguments{
\item{dt}{joined data.table}

\item{var}{variable(s) to be updated}

\item{reportvar}{character: Name of reporting variable. Default is ".joyn".
This is the same as variable "_merge" in Stata after performing a merge. If
FALSE or NULL, the reporting variable will be excluded from the final
table, though a summary of the join will be display after concluding.}

\item{suffixes}{A character(2) specifying the suffixes to be used for making
non-by column names unique. The suffix behaviour works in a similar fashion
as the \link[base:merge]{base::merge} method does.}

\item{rep_NAs}{inherited from joyn update_NAs}

\item{rep_values}{inherited from joyn update_values}
}
\value{
data.table
}
\description{
The function updates NAs and/or values in the following way:
\itemize{
\item If only update_NAs is TRUE: update NAs of var in x with values of var y of the same name
\item If only update_values = TRUE: update all values, but NOT NAs, of var in x with values of var y of the same name.
NAs from y are not used to update values in x . (e.g., if x.var = 10 and y.var = NA, x.var remains 10)
\item If both update_NAs and update_values are TRUE, both NAs and values in x are updated as described above
\item If both update_NAs and update_values are FALSE, no update
}
}
\keyword{internal}
