% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam_cox.R
\name{fit_gam_cox}
\alias{fit_gam_cox}
\title{Fit a GAM-Cox Model with Tensor-Product Spline Surface}
\usage{
fit_gam_cox(
  data,
  covariates = c("age_baseline", "sex"),
  k_marginal = c(5, 5),
  k_additive = 6,
  bs = "tp",
  method = "REML"
)
}
\arguments{
\item{data}{Data frame from \code{.build_transition_data}, containing
\code{time_in_state}, \code{status}, covariate columns, and
\code{eta_*} columns.}

\item{covariates}{Character vector of covariate names.}

\item{k_marginal}{Integer vector of marginal basis dimensions. Default \code{c(5,5)}.}

\item{k_additive}{Integer basis dimension for additive smooth of third
biomarker. Default \code{6}.}

\item{bs}{Spline basis type. Default \code{"tp"}.}

\item{method}{Smoothing method. Default \code{"REML"}.}
}
\value{
A \code{mgcv::gam} object, or \code{NULL} on failure.
}
\description{
Fits a penalized Cox proportional hazards model with a tensor-product
spline surface for the latent biomarker summaries using \code{mgcv::gam}
with \code{family = cox.ph()}.
}
