% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bcbnp.R
\name{plot.bcbnp}
\alias{plot.bcbnp}
\title{Generic plot function for bcbnp object.}
\usage{
\method{plot}{bcbnp}(
  x,
  plot.type = "predictive",
  n.samples = NULL,
  x.lim = NULL,
  y.lim = NULL,
  x.lab = NULL,
  y.lab = "Posterior Predictive Distribution",
  title.plot = NULL,
  show.histogram = TRUE,
  show.rug = NULL,
  binwidth = 0.08,
  adjust = 1,
  density.color = "blue",
  hist.color = "black",
  hist.fill = "grey95",
  rug.color = "green",
  rug.alpha = 1,
  density.alpha = 0.2,
  density.lwd = 1,
  density.lty = 1,
  ...
)
}
\arguments{
\item{x}{The object generated by the bcbnp function (the BC-BNP model output).}

\item{plot.type}{A character string specifying the type of plot:
- "predictive": Plots the posterior predictive distribution of a new study.
- "mu_posterior": Plots the posterior of the overall mean (mu.theta).
- "tau_posterior": Plots the posterior of the between-study standard deviation (tau.theta).}

\item{n.samples}{The number of posterior samples to plot. If NULL, all samples are used.}

\item{x.lim}{Numeric vector of length 2 specifying the x-axis limits.}

\item{y.lim}{Numeric vector of length 2 specifying the y-axis limits.}

\item{x.lab}{Text with the label of the x-axis.}

\item{y.lab}{Text with the label of the y-axis.}

\item{title.plot}{Text for setting a title in the plot.}

\item{show.histogram}{A logical value indicating whether to show the histogram.}

\item{show.rug}{A logical value indicating whether to show the rug plot. Defaults to TRUE for predictive and mu plots, FALSE for tau.}

\item{binwidth}{A numeric value specifying the bin width for the histogram.}

\item{adjust}{A numeric value for the density bandwidth adjustment.}

\item{density.color}{A character value for the density curve color.}

\item{hist.color}{A character value for the histogram border color.}

\item{hist.fill}{A character value for the histogram fill color.}

\item{rug.color}{A character value for the rug plot color.}

\item{rug.alpha}{A numeric value between 0 and 1 for the rug plot transparency.}

\item{density.alpha}{A numeric value for the density curve transparency.}

\item{density.lwd}{A numeric value for the density curve line width.}

\item{density.lty}{A numeric value for the density curve line type.}

\item{...}{\dots}
}
\description{
This function is built with `ggplot2`. Parameters such as `binwidth`, `adjust`, `density.color`, `density.lwd`, and `density.lty` correspond directly to arguments in the `ggplot2` geoms.
}
