% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpmeta.R
\name{dpmeta}
\alias{dpmeta}
\title{Bayesian Meta-Analysis with Dirichlet Process Priors}
\usage{
dpmeta(
  data,
  mean.mu.0 = 0,
  sd.mu.0 = 10,
  scale.sigma.between = 0.5,
  df.scale.between = 1,
  alpha.0 = 0.03,
  alpha.1 = 10,
  K = 30,
  nr.chains = 2,
  nr.iterations = 10000,
  nr.adapt = 1000,
  nr.burnin = 1000,
  nr.thin = 1,
  parallel = NULL
)
}
\arguments{
\item{data}{A data frame with at least two columns with the following names:
1) TE = treatment effect,
2) seTE = the standard error of the treatment effect.}

\item{mean.mu.0}{Prior mean of the mean of the base distribution default value is mean.mu.0 = 0.}

\item{sd.mu.0}{Prior standard deviation of the base distribution, the default value is 10.}

\item{scale.sigma.between}{Prior scale parameter for scale gamma distribution for the
precision between studies. The default value is 0.5.}

\item{df.scale.between}{Degrees of freedom of the scale gamma distribution for the precision between studies.
The default value is 1, which results in a Half Cauchy distribution for the standard
deviation between studies. Larger values e.g. 30 corresponds to a Half Normal distribution.}

\item{alpha.0}{Lower bound of the uniform prior for the concentration parameter for the DPM,
default value is alpha.0 = 0.03.}

\item{alpha.1}{Upper bound of the uniform prior for the concentration parameter for the DPM,
default value is alpha.1 = 10.}

\item{K}{Maximum number of clusters in the DP, default value is K = 30.}

\item{nr.chains}{Number of chains for the MCMC computations, default 2.}

\item{nr.iterations}{Number of iterations after adapting the MCMC, default is 10000. Some models may need more iterations.}

\item{nr.adapt}{Number of iterations in the adaptation process, default is 1000. Some models may need more iterations during adptation.}

\item{nr.burnin}{Number of iteration discard for burn-in period, default is 1000. Some models may need a longer burnin period.}

\item{nr.thin}{Thinning rate, it must be a positive integer, the default value 1}

\item{parallel}{NULL -> jags, 'jags.parallel' -> jags.parallel execution}
}
\value{
This function returns an object of the class "dpmeta". This object contains the MCMC
                           output of each parameter and hyper-parameter in the model and
                           the data frame used for fitting the model.
}
\description{
This function performers a Bayesian meta-analysis with DP as random effects
}
\details{
The results of the object of the class bcmeta can be extracted with R2jags or with rjags. In addition a summary, a print and a plot functions are
implemented for this type of object.
}
\examples{
\dontrun{
library(jarbes)


# Example: Stemcells

data("stemcells")
stemcells$TE = stemcells$effect.size
stemcells$seTE = stemcells$se.effect

bm1 = dpmmeta(stemcells)
summary(bm1)
plot(bm1, x.lim = c(-1, 7), y.lim = c(0, 1))

diagnostic(bm1, study.names = stemcells$trial,
           post.p.value.cut = 0.05,
           lwd.forest = 0.5, shape.forest = 4)

diagnostic(bm1, post.p.value.cut = 0.05,
           lwd.forest = 0.5, shape.forest = 4)
}

}
\references{
Verde, P.E. (2021) A Bias-Corrected Meta-Analysis Model for Combining Studies of Different Types and Quality. Biometrical Journal; 1–17.
}
