% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic.hmr.R
\name{diagnostic.hmr}
\alias{diagnostic.hmr}
\title{Diagnostic function for hmr object in jarbes}
\usage{
\method{diagnostic}{hmr}(
  object,
  median.w = 1.5,
  study.names,
  size.forest = 0.4,
  lwd.forest = 0.2,
  shape.forest = 23,
  mu.phi = TRUE,
  mu.phi.x.lim.low = -10,
  mu.phi.x.lim.up = 10,
  colour.hist.mu.phi = "royalblue",
  colour.prior.mu.phi = "black",
  colour.posterior.mu.phi = "blue",
  title.plot.mu.phi = "Prior-to-Posterior Sensitivity",
  title.plot.weights = "Outlier Detection",
  ...
)
}
\arguments{
\item{object}{The object generated by the function hmr.}

\item{median.w}{Change colour if median of a weight > median.w. The default value is 1.5.}

\item{study.names}{Character vector containing names of the studies used.}

\item{size.forest}{Size of the center symbol mark in the forest-plot lines}

\item{lwd.forest}{Thickness of the lines in the forest-plot}

\item{shape.forest}{Type of symbol for the center mark in the forest-plot lines}

\item{mu.phi}{Prior-to-posterior sensitivity analysis of mu.phi. Default value is TRUE.}

\item{mu.phi.x.lim.low}{Lower limit of the prior to posterior plot for mu.phi}

\item{mu.phi.x.lim.up}{Upper limit of the prior to posterior plot for mu.phi}

\item{colour.hist.mu.phi}{colour of the posterior mu.phi histogram}

\item{colour.prior.mu.phi}{colour of the prior of mu.phi}

\item{colour.posterior.mu.phi}{colour of the posterior of mu.phi}

\item{title.plot.mu.phi}{Text for the title in the mu phi plot.}

\item{title.plot.weights}{Text for the title of the posterior weights.}

\item{...}{\dots}
}
\description{
This function performers a specially designed diagnostic for a hmr object
}
