% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bchmr.R
\name{bchmr}
\alias{bchmr}
\title{Bias-Corrected Bayesian Nonparametric Model to combine aggregated and individual participant data for cross design synthesis.}
\usage{
bchmr(
  data,
  two.by.two = TRUE,
  dataIPD,
  re = "normal",
  mean.mu.1 = 0,
  mean.mu.2 = 0,
  mean.mu.phi = 0,
  sd.mu.1 = 1,
  sd.mu.2 = 1,
  sd.mu.phi = 1,
  sigma.1.upper = 5,
  sigma.2.upper = 5,
  sigma.beta.upper = 5,
  mean.Fisher.rho = 0,
  sd.Fisher.rho = 1/sqrt(2),
  nr.chains = 2,
  nr.iterations = 10000,
  nr.adapt = 1000,
  nr.burnin = 1000,
  nr.thin = 1,
  parallel = NULL
)
}
\arguments{
\item{data}{Aggregated data results: a data frame where the first four columns containing the number of events in
the control group (yc), the number of patients in the control group (nc),
the number of events in the treatment group (yt) and the number of patients in the
treatment group (nt). If two.by.two = TRUE a data frame where each line
contains the trial results with column names: yc, nc, yt, nt.}

\item{two.by.two}{If TRUE indicates that the trial results are with names: yc, nc, yt, nt.}

\item{dataIPD}{Individual participant data: a data frame where
the first column is the outcome variable and the
other columns represent individual participant
charachteristics.}

\item{re}{Random effects distribution for the resulting model. Possible
values are \emph{normal} for bivariate random effects and \emph{sm}
for scale mixtures.}

\item{mean.mu.1}{Prior mean of baseline risk, default value is 0.}

\item{mean.mu.2}{Prior mean of treatment effect, default value is 0.}

\item{mean.mu.phi}{Prior mean of the bias parameter which measures the difference
between the baseline mean mu.1 and the intercept parameter of
the logistic regression of the individual participant data.
The defalut vaule is 0.}

\item{sd.mu.1}{Prior standard deviation of mu.1, default value is 1. The default prior of mu.1 is a
logistic distribution with mean 0 and dispersion 1. The implicit prior for mu.1 in
the probability scale is a uniform between 0 and 1.}

\item{sd.mu.2}{Prior standard deviation of mu.2, default value is 1. The default prior of mu.2 is a
logistic distribution with mean 0 and dispersion 1. The implicit prior for mu.2 in
the probability scale is a uniform between 0 and 1.}

\item{sd.mu.phi}{Prior standard deviation of mu.phi, default value is 1.}

\item{sigma.1.upper}{Upper bound of the uniform prior of sigma.1, default value is 5.}

\item{sigma.2.upper}{Upper bound of the uniform prior of sigma.2, default value is 5.}

\item{sigma.beta.upper}{Upper bound of the uniform prior of sigma.beta, default value is 5.}

\item{mean.Fisher.rho}{Mean of rho in the Fisher scale, default value is 0.}

\item{sd.Fisher.rho}{Standard deviation of rho in the Fisher scale, default value is 1/sqrt(2).}

\item{nr.chains}{Number of chains for the MCMC computations, default 5.}

\item{nr.iterations}{Number of iterations after adapting the MCMC, default is 10000. Some models may need more iterations.}

\item{nr.adapt}{Number of iterations in the adaptation process, default is 1000. Some models may need more iterations during adptation.}

\item{nr.burnin}{Number of iteration discarded for burnin period, default is 1000. Some models may need a longer burnin period.}

\item{nr.thin}{Thinning rate, it must be a positive integer, the default value 1.}

\item{parallel}{NULL -> jags, 'jags.parallel' -> jags.parallel execution}
}
\value{
This function returns an object of the class "bchmr". This object contains the MCMC output of
each parameter and hyper-parameter in the model, the data frame used for fitting the model, and further model outputs.

The results of the object of the class hmr can be extracted with R2jags. In addition
a summary, a print and a plot function are implemented for this type of object.
}
\description{
This function performers a Bayesian cross design synthesis. The function fits a
hierarchical meta-regression model based on a BC-BNP model
}
\details{
The model is experimental and under construction for the version 2.2.5 (March 2025)
}
\examples{

\dontrun{
library(jarbes)

data("healing")
AD <- healing[, c("y_c", "n_c", "y_t", "n_t")]

data("healingipd")

IPD <- healingipd[, c("healing.without.amp", "PAD", "neuropathy",
"first.ever.lesion", "no.continuous.care", "male", "diab.typ2",
"insulin", "HOCHD", "HOS", "CRF", "dialysis", "DNOAP", "smoking.ever",
"diabdur", "wagner.class")]

mx1 <- bchmr(AD, two.by.two = FALSE,
           dataIPD = IPD,
           re = "normal",
           sd.mu.1 = 2,
           sd.mu.2 = 2,
           sd.mu.phi = 2,
           sigma.1.upper = 5,
           sigma.2.upper = 5,
           sigma.beta.upper = 5,
           sd.Fisher.rho = 1.25,
           df.estimate = FALSE,
           df.lower = 3,
           df.upper = 10,
           nr.chains = 1,
           nr.iterations = 1500,
           nr.adapt = 100,
           nr.thin = 1)

print(mx1)


# End of the examples.

}


}
\references{
Verde, P. E. (2019) Learning from Clinical Evidence: The Hierarchical Meta-Regression Approach. Biometrical Journal. Biometrical Journal; 1-23.

Verde, P.E., and Rosner, G.L. (2025), A Bias-Corrected Bayesian Nonparametric Model for Combining Studies With Varying Quality in Meta-Analysis. Biometrical Journal., 67: e70034. https://doi.org/10.1002/bimj.70034
}
