% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{orbi_aggregate_raw}
\alias{orbi_aggregate_raw}
\title{Aggregate data from raw files}
\usage{
orbi_aggregate_raw(
  files_data,
  aggregator = "standard",
  show_progress = rlang::is_interactive(),
  show_problems = TRUE
)
}
\arguments{
\item{files_data}{the files read in by \code{\link[=orbi_read_raw]{orbi_read_raw()}}}

\item{aggregator}{typically the name of a registered aggregator (see all with \code{orbi_get_option("aggregators")}),
default is the "standard" aggregator included in the package (\code{orbi_get_aggregator("standard")}).
Other options are "minimal" (\code{orbi_get_aggregator("minimal")}) and "extended" (\code{orbi_get_aggregator("extended")}).
The \code{aggregator} parameter can can also directly be an aggregator tibble (created/modified with \code{\link[=orbi_start_aggregator]{orbi_start_aggregator()}}
and/or \code{\link[=orbi_add_to_aggregator]{orbi_add_to_aggregator()}}) that defines which data should be aggregated and how.}

\item{show_progress}{whether to show a progress bar, by default always enabled when running interactively e.g. inside RStudio (and disabled in a notebook), turn off with \code{show_progress = FALSE}}

\item{show_problems}{whether to show problems encountered along the way (rather than just keeping track of them with \code{\link[=orbi_get_problems]{orbi_get_problems()}}). Set to \code{show_problems = FALSE} to turn off the live printout. Either way, all encountered problems can be retrieved with running \code{\link[=orbi_get_problems]{orbi_get_problems()}} for the returned list}
}
\value{
a list of merged dataframes collected from the \code{files_data} based on the \code{aggregator} definitions
}
\description{
This function allows dynamic aggregation and validation of data read by \code{\link[=orbi_read_raw]{orbi_read_raw()}}. Like \code{\link[=orbi_read_raw]{orbi_read_raw()}}, it is designed to be fail save by safely catching errors and reporting back on them (see \code{\link[=orbi_get_problems]{orbi_get_problems()}}). This function should work out of the box for most files without additional modification of the \code{aggregator}.
}
