% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_multipliers_create.R
\name{input_multipliers_create}
\alias{input_multipliers_create}
\title{Create input multipliers}
\usage{
input_multipliers_create(
  input_requirements,
  Im,
  multiplier_name = NULL,
  digits = NULL
)
}
\arguments{
\item{input_requirements}{A matrix or vector created by
\code{\link{input_indicator_create}}}

\item{Im}{A Leontief-inverse created by \code{\link{leontief_inverse_create}}.}

\item{multiplier_name}{An optional name to be placed in the key column of the multiplier.
Defaults to \code{NULL}.}

\item{digits}{Rounding digits, defaults to \code{NULL}, in which case
no rounding takes place. Rounding is important if you replicate examples from the literature,
rounding differences can add up to visible differences in matrix equations.}
}
\value{
A data frame with the vector of multipliers and the an
auxiliary metadata column, containing an automatically given row identifier (for joining with other matrixes)
which can be  overruled with setting \code{multiplier_name}.
}
\description{
The function creates the multipliers (direct + indirect effects).
}
\examples{
nl <- netherlands_2000

input_coeff_nl <- input_coefficient_matrix_create(
  data_table = netherlands_2000,
  households = FALSE
)

compensation_indicator <- input_indicator_create(netherlands_2000, "compensation_employees")

I_nl <- leontief_inverse_create(input_coeff_nl)

input_multipliers_create(
  input_requirements = compensation_indicator,
  Im = I_nl
)
}
\seealso{
Other multiplier functions: 
\code{\link{multiplier_create}()},
\code{\link{output_multiplier_create}()}
}
\concept{multiplier functions}
