% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_indicator_create.R
\name{input_indicator_create}
\alias{input_indicator_create}
\title{Create input indicator(s)}
\usage{
input_indicator_create(
  data_table,
  input_row = c("gva_bp", "net_tax_production"),
  digits = NULL,
  households = FALSE,
  indicator_names = NULL
)
}
\arguments{
\item{data_table}{A symmetric input–output table, use table, margins, or
tax table retrieved by \code{\link[=iotable_get]{iotable_get()}}.}

\item{input_row}{Character vector of input row names to extract (e.g.,
\code{"gva"}, \code{"compensation_employees"}). Matching is case-insensitive.}

\item{digits}{Integer number of decimal places for rounding. Default
\code{NULL} (no rounding).}

\item{households}{Logical; include a households column if available.
Default \code{FALSE}.}

\item{indicator_names}{Optional character vector of names for the returned
indicators. If \code{NULL}, names are taken from the key column in the selected
rows of the coefficient matrix and suffixed with \code{"_indicator"}.}
}
\value{
A \code{data.frame} whose first column is a key, followed by the selected
input-indicator rows as numeric columns.
}
\description{
Compute input indicators (e.g., GVA, compensation of employees) by selecting
specific input rows from the input-coefficient matrix.
}
\details{
Let \eqn{A} be the input-coefficient matrix (rows are inputs, columns are
products/industries). An \emph{input indicator} for a given input row \eqn{r} is
simply the row \eqn{A_{r\cdot}}. These indicators are used in Beutel (2012)
and the Eurostat \emph{Manual of Supply, Use and Input-Output Tables} (e.g.,
pp. 495–498) to derive effects and multipliers.

Internally, the function builds \eqn{A} via
\code{\link[=coefficient_matrix_create]{coefficient_matrix_create()}}, then keeps only the requested input
rows and renames the key column to \verb{*_indicator}. Optional rounding is
applied to numeric columns.
}
\examples{
input_indicator_create(
  data_table = iotable_get(),
  input_row = c("gva", "compensation_employees"),
  digits = 4,
  indicator_names = c("GVA indicator", "Income indicator")
)

# Beutel/Eurostat example: GVA indicator (cf. Manual, ~p. 498)
ii <- input_indicator_create(
  data_table = iotable_get(),
  input_row = "gva",
  digits = 4
)
head(ii)

}
\seealso{
Other indicator functions: 
\code{\link{coefficient_matrix_create}()},
\code{\link{direct_effects_create}()}
}
\concept{indicator functions}
