% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_germany_airpol.R
\docType{data}
\name{germany_airpol}
\alias{germany_airpol}
\title{Air pollution table for Germany, 1995}
\format{
A data frame with 72 observations and 4 variables:
\describe{
\item{airpol}{Abbreviation of the air pollutant.}
\item{induse}{Column labels, following Eurostat conventions with minor
differences.}
\item{iotables_col}{Column labels using \code{iotables} abbreviations.}
\item{value}{Values in thousand tons.}
}
}
\source{
Eurostat (2008). \emph{Eurostat Manual of Supply, Use and Input–Output Tables},
p. 482.
Available at \url{https://ec.europa.eu/eurostat/documents/3859598/5902113/KS-RA-07-013-EN.PDF}
}
\usage{
germany_airpol
}
\description{
Air pollution values for validation and cross-checking with the Eurostat
Manual.
}
\details{
This dataset is provided for testing purposes. Labels were slightly adjusted
to reflect the transition from ESA95 to ESA2010 vocabulary since the
publication of the Eurostat Manual.
}
\seealso{
Other validation datasets: 
\code{\link{netherlands_2000}},
\code{\link{uk_test_results}}
}
\concept{validation datasets}
\keyword{datasets}
