% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/employment_get.R
\name{employment_get}
\alias{employment_get}
\title{Get Eurostat employment data for SIOTs}
\source{
Eurostat dataset
\href{https://ec.europa.eu/eurostat/web/products-datasets/-/lfsq_egan22d}{lfsq_egan22d}
}
\usage{
employment_get(
  geo,
  year = "2010",
  sex = "Total",
  age = "Y_GE15",
  labelling = "iotables",
  data_directory = NULL,
  force_download = FALSE
)
}
\arguments{
\item{geo}{A two-letter country code (Eurostat style). \code{"GB"} and \code{"GR"}
are automatically converted to \code{"UK"} and \code{"EL"}.}

\item{year}{Year of employment data (>= 2008, when NACE Rev. 2 was
introduced).}

\item{sex}{Employment by sex. Defaults to \code{"Total"}. Alternatives are
\code{"Female"}/\code{"F"}, \code{"Male"}/\code{"M"}. Case-insensitive.}

\item{age}{Eurostat age code. Defaults to \code{"Y_GE15"}. Any valid Eurostat
code may be supplied (see Eurostat metadata).}

\item{labelling}{Controls output row/column labelling:
\itemize{
\item \code{"iotables"}: iotables manual-style labels
\item \code{"prod_na"}: product × product (CPA codes)
\item \code{"induse"}: industry × industry (NACE codes)
}}

\item{data_directory}{Optional path to save/load pre-processed employment
data (\code{.rds} files). If \code{NULL}, only downloads are used.}

\item{force_download}{Logical. If \code{TRUE}, forces a fresh Eurostat download
even if local cache files exist.}
}
\value{
A one-row \code{data.frame} containing employment input values aligned
with the chosen SIOT labelling, including an imputed rent column set to 0.
}
\description{
Download employment data from Eurostat (dataset
\href{https://ec.europa.eu/eurostat/web/products-datasets/-/lfsq_egan22d}{lfsq_egan22d})
and arrange it to match 64 × 64 symmetric input–output tables (SIOTs).
}
\details{
\itemize{
\item Currently implemented only for product × product tables.
\item Country codes are harmonized: \code{"GB"} → \code{"UK"}, \code{"GR"} → \code{"EL"}.
\item Sex is normalized internally to Eurostat codes \code{"T"}, \code{"F"}, \code{"M"}.
\item Results are cached as \code{.rds} files in \code{data_directory} if supplied.
\item An imputed rent column (\code{L68A}/\code{CPA_L68A}) with zero is always added.
}
}
\examples{
\dontrun{
employment <- employment_get(
  geo = "CZ",
  year = "2010",
  sex = "Total",
  age = "Y_GE15",
  data_directory = NULL,
  force_download = TRUE
)
}
}
\seealso{
Other import functions: 
\code{\link{airpol_get}()},
\code{\link{iotables_download}()},
\code{\link{iotables_metadata_get}()},
\code{\link{iotables_read_tempdir}()}
}
\concept{import functions}
