% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru_index.R
\name{bru_index}
\alias{bru_index}
\alias{bru_index.bru_obs}
\alias{bru_index.bru}
\alias{bru_index.bru_comp}
\alias{bru_index.bru_comp_list}
\alias{bru_index.bru_model}
\alias{index_eval}
\title{Extract predictor or component index information}
\usage{
bru_index(object, ...)

\method{bru_index}{bru_obs}(object, what = NULL, ...)

\method{bru_index}{bru}(object, tag = NULL, what = NULL, ...)

\method{bru_index}{bru_comp}(object, inla_f, ...)

\method{bru_index}{bru_comp_list}(object, inla_f, ...)

\method{bru_index}{bru_model}(object, used, ...)

index_eval(...)
}
\arguments{
\item{object}{A \link{component}.}

\item{\dots}{Arguments passed on to sub-methods.}

\item{what}{\code{character} or \code{NULL}; One of \code{NULL}, "all", "observed", and
"missing". If \code{NULL} (default) or "all", gives the index vector for the
full sub-model predictor. If "observed", gives the index vector for the
observed part (response is not \code{NA}). If "missing", gives the index vector
for the missing part (response is \code{NA}) of the model.}

\item{tag}{\code{character} or \code{integer}; Either a character vector identifying
the tags of one or more of the \code{\link[=bru_obs]{bru_obs()}} observation models, or an
integer vector identifying models by their \code{\link[=bru]{bru()}} specification order. If
\code{NULL} (default) computes indices for all sub-models.}

\item{inla_f}{logical; when \code{TRUE}, must result in
values compatible with \code{INLA::f(...)}
an specification and corresponding \code{INLA::inla.stack(...)} constructions.}

\item{used}{A \code{\link[=bru_used]{bru_used()}} object}
}
\value{
\itemize{
\item \code{bru_index(bru_obs)}: An \code{integer} vector.
}

\itemize{
\item \code{bru_index(bru)}: An \code{integer} vector.
}

\itemize{
\item \code{bru_index(bru_comp)}:
A list of indices into the latent variables compatible with the
component mapper.
}

\itemize{
\item \code{bru_index(bru_comp_list)}:
A list of list of indices into the latent variables compatible with each
component mapper.
}

\itemize{
\item \code{bru_index(bru_model)}: A named list of \code{idx_full} and \code{idx_inla},
named list of indices, and \code{inla_subset}, and \code{inla_subset},
a named list of logical subset specifications for extracting the \code{INLA::f()}
compatible index subsets.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Extract the index vector for a \code{\link[=bru_obs]{bru_obs()}} predictor,
or the whole or a subset of a full \code{\link[=bru]{bru()}} predictor.
}
\section{Methods (by class)}{
\itemize{
\item \code{bru_index(bru_obs)}: Extract the index vector for the predictor vector for a
\code{\link[=bru_obs]{bru_obs()}} sub-model. The indices are relative to the sub-model, and need
to be appropriately offset to be used in the full model predictor.

\item \code{bru_index(bru)}: Extract the index vector for "APredictor" for one or
more specified observation \code{\link[=bru_obs]{bru_obs()}} sub-models. Accepts any combination
of \code{tag} and \code{what}.

\item \code{bru_index(bru_model)}: Compute all index values for a \code{\link[=bru_model]{bru_model()}} object.
Computes the index value matrices for included components according to the
\code{used} argument.

}}
\section{Functions}{
\itemize{
\item \code{index_eval()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} since "2.12.0.9023".
Use \code{bru_index()} instead.

}}
\examples{
\dontshow{if (bru_safe_inla()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
fit <- bru(
  ~ 0 + x,
  bru_obs(
    y ~ .,
    data = data.frame(x = 1:3, y = 1:3 + rnorm(3)),
    tag = "A"
  ),
  bru_obs(
    y ~ .,
    data = data.frame(x = 1:4, y = c(NA, NA, 3:4) + rnorm(4)),
    tag = "B"
  )
)
bru_index(fit)
bru_index(fit, "A")
bru_index(fit, "B")
bru_index(fit, c("B", "A"))
bru_index(fit, what = "missing")
\dontshow{\}) # examplesIf}
}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com},
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\keyword{internal}
