% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHHdata.R
\name{getHHdata}
\alias{getHHdata}
\title{Get Haul Data}
\usage{
getHHdata(survey, year, quarter)
}
\arguments{
\item{survey}{the survey acronym, e.g. NS-IBTS.}

\item{year}{the year of the survey, e.g. 2010.}

\item{quarter}{the quarter of the year the survey took place, i.e. 1, 2, 3 or 4.}
}
\value{
A data frame.
}
\description{
Get haul data such as position, depth, sampling method, etc.
}
\examples{
\dontrun{
hhdata <- getHHdata(survey = "ROCKALL", year = 2002, quarter = 3)
str(hhdata)

# error checking examples:
hhdata <- getHHdata(survey = "NS_IBTS", year = 2016, quarter = 1)
hhdata <- getHHdata(survey = "NS-IBTS", year = 2030, quarter = 1)
hhdata <- getHHdata(survey = "NS-IBTS", year = 2016, quarter = 6)
}
}
\seealso{
\code{\link{getDATRAS}} supports querying many years and quarters in one function call.

\code{\link{getHLdata}} and \code{\link{getCAdata}} get length-based data and
age-based data.

\code{\link{icesDatras-package}} gives an overview of the package.
}
\author{
Colin Millar.
}
